/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.Map;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalOrder;
import org.opengis.temporal.TemporalPrimitive;

public abstract class DefaultTemporalPrimitive
extends AbstractIdentifiedObject
implements TemporalPrimitive,
TemporalOrder {
    public DefaultTemporalPrimitive(Map<String, ?> properties) throws IllegalArgumentException {
        super(properties);
    }

    protected DefaultTemporalPrimitive() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    protected DefaultTemporalPrimitive(TemporalPrimitive object) {
        super((IdentifiedObject)object);
    }

    public RelativePosition relativePosition(TemporalPrimitive other) {
        if (this instanceof Instant && other instanceof Instant) {
            Instant timeobject = (Instant)this;
            Instant instantOther = (Instant)other;
            if (timeobject.getDate() == null || instantOther.getDate() == null) {
                if (timeobject.getDate() != null && instantOther.getTemporalPosition() != null && instantOther.getTemporalPosition().getIndeterminatePosition() != null) {
                    IndeterminateValue indeterminatePosition = instantOther.getTemporalPosition().getIndeterminatePosition();
                    if (indeterminatePosition == IndeterminateValue.AFTER) {
                        return RelativePosition.AFTER;
                    }
                    if (indeterminatePosition == IndeterminateValue.BEFORE) {
                        return RelativePosition.BEFORE;
                    }
                    if (indeterminatePosition == IndeterminateValue.NOW) {
                        long currentMillis = System.currentTimeMillis();
                        long toMillis = timeobject.getDate().getTime();
                        if (toMillis > currentMillis) {
                            return RelativePosition.AFTER;
                        }
                        if (toMillis < currentMillis) {
                            return RelativePosition.BEFORE;
                        }
                        return RelativePosition.EQUALS;
                    }
                } else if (instantOther.getDate() != null && timeobject.getTemporalPosition() != null && timeobject.getTemporalPosition().getIndeterminatePosition() != null) {
                    IndeterminateValue indeterminatePosition = timeobject.getTemporalPosition().getIndeterminatePosition();
                    if (indeterminatePosition == IndeterminateValue.AFTER) {
                        return RelativePosition.AFTER;
                    }
                    if (indeterminatePosition == IndeterminateValue.BEFORE) {
                        return RelativePosition.BEFORE;
                    }
                    if (indeterminatePosition == IndeterminateValue.NOW) {
                        long currentMillis = System.currentTimeMillis();
                        long toMillis = instantOther.getDate().getTime();
                        if (toMillis > currentMillis) {
                            return RelativePosition.BEFORE;
                        }
                        if (toMillis < currentMillis) {
                            return RelativePosition.AFTER;
                        }
                        return RelativePosition.EQUALS;
                    }
                }
                return null;
            }
            if (timeobject.getDate().before(instantOther.getDate())) {
                return RelativePosition.BEFORE;
            }
            return timeobject.getDate().compareTo(instantOther.getDate()) == 0 ? RelativePosition.EQUALS : RelativePosition.AFTER;
        }
        if (this instanceof Period && other instanceof Instant) {
            Period timeobject = (Period)this;
            Instant instantarg = (Instant)other;
            if (timeobject.getEnding().getDate().before(instantarg.getDate())) {
                return RelativePosition.BEFORE;
            }
            if (timeobject.getEnding().getDate().compareTo(instantarg.getDate()) == 0) {
                return RelativePosition.ENDED_BY;
            }
            if (timeobject.getBeginning().getDate().before(instantarg.getDate()) && timeobject.getEnding().getDate().after(instantarg.getDate())) {
                return RelativePosition.CONTAINS;
            }
            return timeobject.getBeginning().getDate().compareTo(instantarg.getDate()) == 0 ? RelativePosition.BEGUN_BY : RelativePosition.AFTER;
        }
        if (this instanceof Instant && other instanceof Period) {
            Instant timeobject = (Instant)this;
            Period instantarg = (Period)other;
            if (instantarg.getEnding().getDate().before(timeobject.getDate())) {
                return RelativePosition.AFTER;
            }
            if (instantarg.getEnding().getDate().compareTo(timeobject.getDate()) == 0) {
                return RelativePosition.ENDS;
            }
            if (instantarg.getBeginning().getDate().before(timeobject.getDate()) && instantarg.getEnding().getDate().after(timeobject.getDate())) {
                return RelativePosition.DURING;
            }
            return instantarg.getBeginning().getDate().compareTo(timeobject.getDate()) == 0 ? RelativePosition.BEGINS : RelativePosition.BEFORE;
        }
        if (this instanceof Period && other instanceof Period) {
            Period timeobject = (Period)this;
            Period instantarg = (Period)other;
            if (timeobject.getEnding().getDate().before(instantarg.getBeginning().getDate())) {
                return RelativePosition.BEFORE;
            }
            if (timeobject.getEnding().getDate().compareTo(instantarg.getBeginning().getDate()) == 0) {
                return RelativePosition.MEETS;
            }
            if (timeobject.getBeginning().getDate().before(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().after(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().before(instantarg.getEnding().getDate())) {
                return RelativePosition.OVERLAPS;
            }
            if (timeobject.getBeginning().getDate().compareTo(instantarg.getBeginning().getDate()) == 0 && timeobject.getEnding().getDate().before(instantarg.getEnding().getDate())) {
                return RelativePosition.BEGINS;
            }
            if (timeobject.getBeginning().getDate().compareTo(instantarg.getBeginning().getDate()) == 0 && timeobject.getEnding().getDate().after(instantarg.getEnding().getDate())) {
                return RelativePosition.BEGUN_BY;
            }
            if (timeobject.getBeginning().getDate().after(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().before(instantarg.getEnding().getDate())) {
                return RelativePosition.DURING;
            }
            if (timeobject.getBeginning().getDate().before(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().after(instantarg.getEnding().getDate())) {
                return RelativePosition.CONTAINS;
            }
            if (timeobject.getBeginning().getDate().compareTo(instantarg.getBeginning().getDate()) == 0 && timeobject.getEnding().getDate().compareTo(instantarg.getEnding().getDate()) == 0) {
                return RelativePosition.EQUALS;
            }
            if (timeobject.getBeginning().getDate().after(instantarg.getBeginning().getDate()) && timeobject.getBeginning().getDate().before(instantarg.getEnding().getDate()) && timeobject.getEnding().getDate().after(instantarg.getEnding().getDate())) {
                return RelativePosition.OVERLAPPED_BY;
            }
            if (timeobject.getBeginning().getDate().after(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().compareTo(instantarg.getEnding().getDate()) == 0) {
                return RelativePosition.ENDS;
            }
            if (timeobject.getBeginning().getDate().before(instantarg.getBeginning().getDate()) && timeobject.getEnding().getDate().compareTo(instantarg.getEnding().getDate()) == 0) {
                return RelativePosition.ENDED_BY;
            }
            return timeobject.getBeginning().getDate().compareTo(instantarg.getEnding().getDate()) == 0 ? RelativePosition.MET_BY : RelativePosition.AFTER;
        }
        return null;
    }
}

