/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Map;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.util.ObjectConverters;

final class PropertiesConverter
extends SurjectiveConverter<String, String> {
    private static final PropertiesConverter CODE_INCLUDED = new PropertiesConverter(false);
    private static final PropertiesConverter CODE_INFERED = new PropertiesConverter(true);
    private final boolean rename;

    private PropertiesConverter(boolean rename) {
        this.rename = rename;
    }

    static Map<String, ?> convert(Map<String, ?> properties) {
        return ObjectConverters.derivedKeys(properties, properties.containsKey("code") ? CODE_INCLUDED : CODE_INFERED, Object.class);
    }

    @Override
    public Class<String> getSourceClass() {
        return String.class;
    }

    @Override
    public Class<String> getTargetClass() {
        return String.class;
    }

    @Override
    public String apply(String key) {
        if (key != null) {
            if (key.equals("name")) {
                return this.rename ? "code" : null;
            }
            if (key.startsWith("remarks")) {
                return null;
            }
        }
        return key;
    }
}

