/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public final class AffineTransforms2D
extends Static {
    private AffineTransforms2D() {
    }

    public static AffineTransform castOrCopy(MathTransform transform) throws IllegalArgumentException {
        if (transform == null || transform instanceof AffineTransform) {
            return (AffineTransform)transform;
        }
        if (transform instanceof LinearTransform) {
            return AffineTransforms2D.castOrCopy(((LinearTransform)transform).getMatrix());
        }
        throw new IllegalArgumentException(Resources.format((short)59));
    }

    public static AffineTransform castOrCopy(Matrix matrix) throws IllegalArgumentException {
        if (matrix == null || matrix instanceof AffineTransform) {
            return (AffineTransform)matrix;
        }
        MatrixSIS.ensureSizeMatch(3, 3, matrix);
        if (!Matrices.isAffine(matrix)) {
            throw new IllegalArgumentException(Resources.format((short)59));
        }
        return new AffineTransform(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
    }

    public static Matrix3 toMatrix(AffineTransform transform) {
        return new Matrix3(transform.getScaleX(), transform.getShearX(), transform.getTranslateX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateY(), 0.0, 0.0, 1.0);
    }

    public static LinearTransform toMathTransform(AffineTransform transform) {
        if (transform == null || transform instanceof LinearTransform) {
            return (LinearTransform)((Object)transform);
        }
        return new AffineTransform2D(transform);
    }

    public static Shape transform(AffineTransform transform, Shape shape, boolean allowOverwrite) {
        ArgumentChecks.ensureNonNull("transform", transform);
        if (shape == null) {
            return null;
        }
        int type = transform.getType();
        if (type == 0) {
            return shape;
        }
        if ((type & 0x30) == 0) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rect = (Rectangle2D)shape;
                return AffineTransforms2D.transform(transform, rect, allowOverwrite ? rect : null);
            }
            if ((type & 0x58) == 0 && shape instanceof RectangularShape) {
                RectangularShape rect = (RectangularShape)shape;
                if (!allowOverwrite) {
                    rect = (RectangularShape)rect.clone();
                }
                Rectangle2D frame = rect.getFrame();
                rect.setFrame(AffineTransforms2D.transform(transform, frame, frame));
                return rect;
            }
        }
        if (shape instanceof Path2D) {
            Path2D path = (Path2D)shape;
            if (allowOverwrite) {
                path.transform(transform);
            } else {
                shape = path.createTransformedShape(transform);
            }
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            if (allowOverwrite) {
                area.transform(transform);
            } else {
                shape = area.createTransformedArea(transform);
            }
        } else {
            shape = new Path2D.Double(shape, transform);
        }
        return shape;
    }

    public static Rectangle2D transform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) {
        ArgumentChecks.ensureNonNull("transform", transform);
        if (bounds == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new IntervalRectangle(xmin, ymin, xmax, ymax);
    }

    public static Rectangle2D inverseTransform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) throws NoninvertibleTransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        if (bounds == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.inverseTransform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new IntervalRectangle(xmin, ymin, xmax, ymax);
    }

    public static Point2D inverseDeltaTransform(AffineTransform transform, Point2D vector, Point2D dest) throws NoninvertibleTransformException {
        double m10;
        double m01;
        double m11;
        ArgumentChecks.ensureNonNull("transform", transform);
        if (vector == null) {
            return null;
        }
        double m00 = transform.getScaleX();
        double det = m00 * (m11 = transform.getScaleY()) - (m01 = transform.getShearX()) * (m10 = transform.getShearY());
        if (!(Math.abs(det) > Double.MIN_VALUE)) {
            throw new NoninvertibleTransformException(null);
        }
        double x0 = vector.getX();
        double y0 = vector.getY();
        double x = (x0 * m11 - y0 * m01) / det;
        double y = (y0 * m00 - x0 * m10) / det;
        if (dest != null) {
            dest.setLocation(x, y);
            return dest;
        }
        return new Point2D.Double(x, y);
    }

    public static int getSwapXY(AffineTransform transform) {
        ArgumentChecks.ensureNonNull("transform", transform);
        int flip = AffineTransforms2D.getFlip(transform);
        if (flip != 0) {
            double scaleX = AffineTransforms2D.getScaleX0(transform);
            double scaleY = AffineTransforms2D.getScaleY0(transform) * (double)flip;
            double y = Math.abs(transform.getShearY() / scaleY - transform.getShearX() / scaleX);
            double x = Math.abs(transform.getScaleY() / scaleY + transform.getScaleX() / scaleX);
            if (x > y) {
                return 1;
            }
            if (x < y) {
                return -1;
            }
        }
        return 0;
    }

    public static double getRotation(AffineTransform transform) {
        ArgumentChecks.ensureNonNull("transform", transform);
        int flip = AffineTransforms2D.getFlip(transform);
        if (flip != 0) {
            double scaleX = AffineTransforms2D.getScaleX0(transform);
            double scaleY = AffineTransforms2D.getScaleY0(transform) * (double)flip;
            return Math.atan2(transform.getShearY() / scaleY - transform.getShearX() / scaleX, transform.getScaleY() / scaleY + transform.getScaleX() / scaleX);
        }
        return Double.NaN;
    }

    public static int getFlip(AffineTransform transform) {
        ArgumentChecks.ensureNonNull("transform", transform);
        double scaleX = Math.signum(transform.getScaleX());
        double scaleY = Math.signum(transform.getScaleY());
        double shearX = Math.signum(transform.getShearX());
        double shearY = Math.signum(transform.getShearY());
        if (scaleX == scaleY && shearX == -shearY) {
            return 1;
        }
        if (scaleX == -scaleY && shearX == shearY) {
            return -1;
        }
        return 0;
    }

    public static double getScaleX0(AffineTransform transform) {
        ArgumentChecks.ensureNonNull("transform", transform);
        double scale = transform.getScaleX();
        double shear = transform.getShearX();
        if (shear == 0.0) {
            return Math.abs(scale);
        }
        if (scale == 0.0) {
            return Math.abs(shear);
        }
        return Math.hypot(scale, shear);
    }

    public static double getScaleY0(AffineTransform transform) {
        ArgumentChecks.ensureNonNull("transform", transform);
        double scale = transform.getScaleY();
        double shear = transform.getShearY();
        if (shear == 0.0) {
            return Math.abs(scale);
        }
        if (scale == 0.0) {
            return Math.abs(shear);
        }
        return Math.hypot(scale, shear);
    }

    public static double getScale(AffineTransform tr) {
        return 0.5 * (AffineTransforms2D.getScaleX0(tr) + AffineTransforms2D.getScaleY0(tr));
    }
}

