/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.referencing;

import java.util.ArrayList;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.DefaultCompoundCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRSUtilities
extends Static {
    private CRSUtilities() {
    }

    public static int getDimensionOf(CoordinateReferenceSystem crs, Class<? extends CoordinateReferenceSystem> type) throws IllegalArgumentException {
        if (type.isAssignableFrom(crs.getClass())) {
            return 0;
        }
        if (crs instanceof CompoundCRS) {
            int offset = 0;
            for (CoordinateReferenceSystem ci : ((CompoundCRS)crs).getComponents()) {
                int index = CRSUtilities.getDimensionOf(ci, type);
                if (index >= 0) {
                    return index + offset;
                }
                offset += ci.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem crs) throws TransformException {
        if (crs != null) {
            CoordinateReferenceSystem original = crs;
            while (crs.getCoordinateSystem().getDimension() != 2) {
                if (crs instanceof CompoundCRS) {
                    crs = (CoordinateReferenceSystem)((CompoundCRS)crs).getComponents().get(0);
                    continue;
                }
                if ((crs = CRS.getHorizontalComponent((CoordinateReferenceSystem)crs)) != null) continue;
                throw new TransformException(Errors.format((short)19, original.getName()));
            }
        }
        return crs;
    }

    public static Envelope appendMissingDimensions(Envelope envelope, CompoundCRS crs) {
        GeneralEnvelope expanded;
        ArrayList<Object> toAdd = new ArrayList<Object>(4);
        CoordinateReferenceSystem currentCRS = envelope.getCoordinateReferenceSystem();
        CoordinateSystem currentCS = currentCRS.getCoordinateSystem();
        for (SingleCRS subCRS : CRS.getSingleComponents((CoordinateReferenceSystem)crs)) {
            CoordinateSystem subCS = subCRS.getCoordinateSystem();
            if (subCS.getDimension() != 1 || AxisDirections.indexOfColinear((CoordinateSystem)currentCS, (CoordinateSystem)subCS) >= 0) continue;
            toAdd.add(subCRS);
        }
        if (toAdd.isEmpty()) {
            return envelope;
        }
        toAdd.add(0, currentCRS);
        try {
            expanded = new GeneralEnvelope(CRS.compound((CoordinateReferenceSystem[])toAdd.toArray(new CoordinateReferenceSystem[toAdd.size()])));
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("Illegal CRS.", e);
        }
        expanded.setToNaN();
        expanded.subEnvelope(0, envelope.getDimension()).setEnvelope(envelope);
        return expanded;
    }

    public static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem) {
        Unit unit = Units.DEGREE;
        int i = coordinateSystem.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = coordinateSystem.getAxis(i);
            Unit candidate = axis.getUnit();
            if (!Units.isAngular((Unit)candidate)) continue;
            unit = candidate.asType(Angle.class);
            if (!AxisDirection.EAST.equals(AxisDirections.absolute((AxisDirection)axis.getDirection()))) continue;
            break;
        }
        return unit;
    }

    public static Quantity<?> getHorizontalResolution(CoordinateReferenceSystem crs, double ... resolution) {
        int s;
        CoordinateSystem hcs;
        Unit unit;
        SingleCRS horizontalCRS;
        if (resolution != null && (horizontalCRS = CRS.getHorizontalComponent((CoordinateReferenceSystem)crs)) != null && (unit = ReferencingUtilities.getUnit((CoordinateSystem)(hcs = horizontalCRS.getCoordinateSystem()))) != null && (s = AxisDirections.indexOfColinear((CoordinateSystem)crs.getCoordinateSystem(), (CoordinateSystem)hcs)) >= 0) {
            int dim = hcs.getDimension();
            double min = Double.POSITIVE_INFINITY;
            for (int i = s; i < dim; ++i) {
                double r = resolution[i];
                if (!(r > 0.0) || !(r < min)) continue;
                min = r;
            }
            if (min != Double.POSITIVE_INFINITY) {
                return Quantities.create((double)min, (Unit)unit);
            }
        }
        return null;
    }

    public static CoordinateReferenceSystem shiftAxisRange(CoordinateReferenceSystem crs, AxesConvention type) {
        DefaultCompoundCRS impl;
        DefaultCompoundCRS shifted;
        if (crs instanceof GeographicCRS) {
            DefaultGeographicCRS impl2 = DefaultGeographicCRS.castOrCopy((GeographicCRS)((GeographicCRS)crs));
            DefaultGeographicCRS shifted2 = impl2.forConvention(type);
            if (shifted2 != impl2) {
                return shifted2;
            }
        } else if (crs instanceof CompoundCRS && (shifted = (impl = DefaultCompoundCRS.castOrCopy((CompoundCRS)((CompoundCRS)crs))).forConvention(type)) != impl) {
            return shifted;
        }
        return crs;
    }

    public static int firstHorizontalAxis(CoordinateReferenceSystem crs) {
        int tempOrdinate = 0;
        for (CoordinateReferenceSystem component : CRS.getSingleComponents((CoordinateReferenceSystem)crs)) {
            CoordinateSystem cs = component.getCoordinateSystem();
            if (cs instanceof CartesianCS || cs instanceof SphericalCS || cs instanceof EllipsoidalCS) {
                return tempOrdinate;
            }
            tempOrdinate += cs.getDimension();
        }
        throw new IllegalArgumentException("crs doesn't have any horizontal crs");
    }

    public static Class<? extends IdentifiedObject> getReferencingGroup(Class<? extends IdentifiedObject> type) {
        Class<CoordinateReferenceSystem> found = null;
        if (type != null) {
            int i = 0;
            block8: while (true) {
                Class<CoordinateReferenceSystem> candidate;
                switch (i) {
                    case 0: {
                        candidate = CoordinateReferenceSystem.class;
                        break;
                    }
                    case 1: {
                        candidate = CoordinateSystem.class;
                        break;
                    }
                    case 2: {
                        candidate = CoordinateSystemAxis.class;
                        break;
                    }
                    case 3: {
                        candidate = Datum.class;
                        break;
                    }
                    case 4: {
                        candidate = Ellipsoid.class;
                        break;
                    }
                    case 5: {
                        candidate = PrimeMeridian.class;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                if (candidate.isAssignableFrom(type)) {
                    if (found != null) {
                        return IdentifiedObject.class;
                    }
                    found = candidate;
                }
                ++i;
            }
            if (found == null) {
                return IdentifiedObject.class;
            }
        }
        return found;
    }
}

