/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.geotoolkit.resources.Errors;

public class LineFormat
extends Format {
    private static final long serialVersionUID = 1257759127594136266L;
    private static final Predicate<Class> NUMBER = Number.class::isAssignableFrom;
    private transient int count;
    private Object[] data;
    private final Format[] formats;
    private transient ParsePosition position = new ParsePosition(0);
    private int[] limits;
    private String line;
    private transient ObjectConverter<?, ? extends Number> toNumber;

    public LineFormat() {
        this(NumberFormat.getNumberInstance());
    }

    public LineFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale));
    }

    public LineFormat(Format format) {
        if (format == null) {
            throw new NullArgumentException(Errors.format((short)146, 0, 1));
        }
        this.data = new Object[16];
        this.limits = new int[this.data.length + 1];
        this.formats = new Format[]{format};
    }

    public LineFormat(Format[] formats) {
        if (formats.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)38));
        }
        formats = (Format[])formats.clone();
        this.formats = formats;
        this.data = new Object[formats.length];
        this.limits = new int[formats.length + 1];
        for (int i = 0; i < formats.length; ++i) {
            if (formats[i] != null) continue;
            throw new NullArgumentException(Errors.format((short)146, i + 1, formats.length));
        }
    }

    public Class<?> getElementType(Predicate<Class> filter) {
        Class type = null;
        Class[] arguments = new Class[]{String.class};
        for (Format format : this.formats) {
            Class candidate;
            try {
                candidate = format.getClass().getMethod("parse", arguments).getReturnType();
            }
            catch (NoSuchMethodException e) {
                return Object.class;
            }
            if (type == null) {
                type = candidate;
                continue;
            }
            if (candidate == null || filter != null && !filter.test(candidate)) continue;
            type = Classes.findCommonClass(type, candidate);
        }
        return type;
    }

    public void clear() {
        this.toNumber = null;
        this.line = null;
        this.count = 0;
        Arrays.fill(this.data, null);
    }

    public int setLine(String line) throws ParseException {
        return this.setLine(line, 0, line.length());
    }

    public int setLine(String line, int lower, int upper) throws ParseException {
        this.line = line;
        Arrays.fill(this.data, null);
        this.count = 0;
        while (lower < upper) {
            if (Character.isWhitespace(line.charAt(lower))) {
                ++lower;
                continue;
            }
            this.position.setIndex(lower);
            Object datum = this.formats[Math.min(this.count, this.formats.length - 1)].parseObject(line, this.position);
            int next = this.position.getIndex();
            if (datum == null || next <= lower) {
                int error;
                int end;
                for (end = error = this.position.getErrorIndex(); end < upper && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
                throw new ParseException(Errors.format((short)150, line.substring(lower, end).trim(), line.substring(error, Math.min(error + 1, end))), error);
            }
            if (this.count >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.count + Math.min(this.count, 256));
                this.limits = Arrays.copyOf(this.limits, this.data.length + 1);
            }
            this.limits[this.count] = lower;
            this.data[this.count++] = datum;
            lower = next;
        }
        this.limits[this.count] = lower;
        return this.count;
    }

    public int getValueCount() {
        return this.count;
    }

    public void setValues(Object values) throws IllegalArgumentException {
        int length = Array.getLength(values);
        this.data = ArraysExt.resize((Object[])this.data, (int)length);
        this.limits = ArraysExt.resize((int[])this.limits, (int)(length + 1));
        for (int i = 0; i < length; ++i) {
            this.data[i] = Array.get(values, i);
        }
        this.count = length;
    }

    public void setValue(int index, Object value) throws ArrayIndexOutOfBoundsException {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (value == null) {
            throw new NullArgumentException(Errors.format((short)145, "value"));
        }
        if (index == this.count) {
            if (index == this.data.length) {
                this.data = Arrays.copyOf(this.data, index + Math.min(index, 256));
                this.limits = Arrays.copyOf(this.limits, this.data.length + 1);
            }
            ++this.count;
        }
        this.data[index] = value;
    }

    public Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.count) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    private Number getNumber(int index) throws ParseException {
        Object candidate = this.data[index];
        if (candidate instanceof Number) {
            return (Number)candidate;
        }
        try {
            if (this.toNumber == null) {
                Class<?> type = this.getElementType(NUMBER.negate());
                this.toNumber = ObjectConverters.find(type, Number.class);
            }
            Number n = (Number)this.toNumber.apply(candidate);
            return n;
        }
        catch (UnconvertibleObjectException cause) {
            ParseException exception = new ParseException(Errors.format((short)196, this.data[index]), this.limits[index]);
            exception.initCause(cause);
            throw exception;
        }
    }

    public double[] getValues(double[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new double[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).doubleValue();
        }
        return array;
    }

    public float[] getValues(float[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new float[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).floatValue();
        }
        return array;
    }

    public long[] getValues(long[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new long[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.longValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public int[] getValues(int[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new int[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.intValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public short[] getValues(short[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new short[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.shortValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public byte[] getValues(byte[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new byte[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.byteValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    private void checkLength(int expected) throws ParseException {
        if (this.count != expected) {
            int lower = this.limits[Math.min(this.count, expected)];
            int upper = this.limits[Math.min(this.count, expected + 1)];
            throw new ParseException(Errors.format(this.count < expected ? (short)88 : 87, this.count, expected, this.line.substring(lower, upper).trim()), lower);
        }
    }

    private ParseException notAnInteger(int i) {
        return new ParseException(Errors.format((short)143, this.line.substring(this.limits[i], this.limits[i + 1])), this.limits[i]);
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }

    private StringBuffer toString(StringBuffer buffer) {
        FieldPosition field = new FieldPosition(0);
        for (int i = 0; i < this.count; ++i) {
            if (i != 0) {
                buffer.append('\t');
            }
            buffer = this.formats[Math.min(this.formats.length - 1, i)].format(this.data[i], buffer, field);
        }
        return buffer;
    }

    @Override
    public StringBuffer format(Object values, StringBuffer toAppendTo, FieldPosition position) {
        this.setValues(values);
        return this.toString(toAppendTo);
    }

    private static int getLineEnd(String source, int offset, boolean s) {
        char c;
        int length = source.length();
        while (offset < length && ((c = source.charAt(offset)) == '\r' || c == '\n') != s) {
            ++offset;
        }
        return offset;
    }

    public Object[] parseObject(String source, ParsePosition position) {
        int lower = position.getIndex();
        int upper = LineFormat.getLineEnd(source, lower, true);
        try {
            this.setLine(source.substring(lower, upper));
            position.setIndex(LineFormat.getLineEnd(source, upper, false));
            return Arrays.copyOf(this.data, this.count);
        }
        catch (ParseException e) {
            position.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    public Object[] parseObject(String source) throws ParseException {
        this.setLine(source.substring(0, LineFormat.getLineEnd(source, 0, true)));
        return Arrays.copyOf(this.data, this.count);
    }

    @Override
    public LineFormat clone() {
        LineFormat copy = (LineFormat)super.clone();
        copy.data = (Object[])this.data.clone();
        copy.limits = (int[])this.limits.clone();
        return copy;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.data = ArraysExt.resize((Object[])this.data, (int)this.count);
        this.limits = ArraysExt.resize((int[])this.limits, (int)(this.count + 1));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.count = this.data.length;
        this.position = new ParsePosition(0);
    }
}

