/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.referencing.operation.MathTransform;

public final class DecimateJTSLineIterator
extends JTSGeometryIterator<LineString> {
    private final CoordinateSequence coordinates;
    private final int coordinateCount;
    private final boolean isClosed;
    private int lastCoord = 0;
    private int currentIndex = 0;
    private boolean done = false;
    private final double[] resolution;
    private final double[] currentCoord = new double[2];

    public DecimateJTSLineIterator(LineString ls, MathTransform trs, double[] resolution) {
        super(ls, trs);
        this.coordinates = ls.getCoordinateSequence();
        this.coordinateCount = this.coordinates.size();
        this.isClosed = ls instanceof LinearRing;
        this.resolution = resolution;
        this.currentCoord[0] = this.coordinates.getX(0);
        this.currentCoord[1] = this.coordinates.getY(0);
    }

    @Override
    public void reset() {
        this.done = false;
        this.currentIndex = 0;
        this.currentCoord[0] = this.coordinates.getX(0);
        this.currentCoord[1] = this.coordinates.getY(0);
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        block2: {
            double candidateY;
            double candidateX;
            do {
                if (this.currentIndex == this.coordinateCount - 1 && !this.isClosed || this.currentIndex == this.coordinateCount && this.isClosed) {
                    this.done = true;
                    break block2;
                }
                ++this.currentIndex;
                candidateX = this.coordinates.getX(this.currentIndex);
                candidateY = this.coordinates.getY(this.currentIndex);
            } while (!(Math.abs(candidateX - this.currentCoord[0]) >= this.resolution[0]) && !(Math.abs(candidateY - this.currentCoord[1]) >= this.resolution[1]));
            this.currentCoord[0] = candidateX;
            this.currentCoord[1] = candidateY;
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentIndex == 0) {
            this.safeTransform(this.currentCoord, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentIndex == this.coordinateCount && this.isClosed) {
            return 4;
        }
        this.safeTransform(this.currentCoord, 0, coords, 0, 1);
        return 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentIndex == 0) {
            this.safeTransform(this.currentCoord, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentIndex == this.coordinateCount && this.isClosed) {
            return 4;
        }
        this.safeTransform(this.currentCoord, 0, coords, 0, 1);
        return 1;
    }
}

