/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Tuple1i;
import org.geotoolkit.geometry.math.Tuple2i;
import org.geotoolkit.geometry.math.Tuple3i;
import org.geotoolkit.geometry.math.Vector;
import org.geotoolkit.geometry.math.Vector1d;
import org.geotoolkit.geometry.math.Vector1f;
import org.geotoolkit.geometry.math.Vector2d;
import org.geotoolkit.geometry.math.Vector2f;
import org.geotoolkit.geometry.math.Vector3d;
import org.geotoolkit.geometry.math.Vector3f;

public final class Vectors {
    private Vectors() {
    }

    public static Tuple createInt(int dimension) {
        switch (dimension) {
            case 1: {
                return new Tuple1i();
            }
            case 2: {
                return new Tuple2i();
            }
            case 3: {
                return new Tuple3i();
            }
        }
        throw new IllegalArgumentException("Unsupported vector size " + dimension);
    }

    public static Vector createFloat(int dimension) {
        switch (dimension) {
            case 1: {
                return new Vector1f();
            }
            case 2: {
                return new Vector2f();
            }
            case 3: {
                return new Vector3f();
            }
        }
        throw new IllegalArgumentException("Unsupported vector size " + dimension);
    }

    public static Vector createDouble(int dimension) {
        switch (dimension) {
            case 1: {
                return new Vector1d();
            }
            case 2: {
                return new Vector2d();
            }
            case 3: {
                return new Vector3d();
            }
        }
        throw new IllegalArgumentException("Unsupported vector size " + dimension);
    }

    public static double length(double[] vector) {
        return Math.sqrt(Vectors.lengthSquare(vector));
    }

    public static float length(float[] vector) {
        return (float)Math.sqrt(Vectors.lengthSquare(vector));
    }

    public static double lengthSquare(double[] vector) {
        double length = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            length += vector[i] * vector[i];
        }
        return length;
    }

    public static float lengthSquare(float[] vector) {
        float length = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            length += vector[i] * vector[i];
        }
        return length;
    }

    public static double shortestAngle(double[] vector, double[] other) {
        return Math.acos(Vectors.cos(vector, other));
    }

    public static float shortestAngle(float[] vector, float[] other) {
        return (float)Math.acos(Vectors.cos(vector, other));
    }

    public static double cos(double[] vector, double[] other) {
        return Vectors.dot(vector, other) / (Vectors.length(vector) * Vectors.length(other));
    }

    public static float cos(float[] vector, float[] other) {
        return Vectors.dot(vector, other) / (Vectors.length(vector) * Vectors.length(other));
    }

    public static double sin(double[] vector, double[] other) {
        if (vector.length == 2) {
            return (vector[0] * other[1] - vector[1] * other[0]) / (Vectors.length(vector) * Vectors.length(other));
        }
        if (vector.length == 3) {
            return Vectors.length(Vectors.cross(vector, other)) / (Vectors.length(vector) * Vectors.length(other));
        }
        throw new IllegalArgumentException(" Vector size must be 2 or 3");
    }

    public static float sin(float[] vector, float[] other) {
        if (vector.length == 2) {
            return (vector[0] * other[1] - vector[1] * other[0]) / (Vectors.length(vector) * Vectors.length(other));
        }
        if (vector.length == 3) {
            return Vectors.length(Vectors.cross(vector, other)) / (Vectors.length(vector) * Vectors.length(other));
        }
        throw new IllegalArgumentException(" Vector size must be 2 or 3");
    }

    public static void copy(double[] target, double[] src) {
        if (src.length < target.length) {
            throw new IllegalArgumentException(" Source vector size must be equal or greater than target vector");
        }
        System.arraycopy(src, 0, target, 0, target.length);
    }

    public static double[] add(double[] vector, double[] other) {
        return Vectors.add(vector, other, null);
    }

    public static float[] add(float[] vector, float[] other) {
        return Vectors.add(vector, other, null);
    }

    public static double[] subtract(double[] vector, double[] other) {
        return Vectors.subtract(vector, other, null);
    }

    public static float[] subtract(float[] vector, float[] other) {
        return Vectors.subtract(vector, other, null);
    }

    public static double[] multiply(double[] vector, double[] other) {
        return Vectors.multiply(vector, other, null);
    }

    public static float[] multiply(float[] vector, float[] other) {
        return Vectors.multiply(vector, other, null);
    }

    public static double[] divide(double[] vector, double[] other) {
        return Vectors.divide(vector, other, null);
    }

    public static float[] divide(float[] vector, float[] other) {
        return Vectors.divide(vector, other, null);
    }

    public static double[] scale(double[] vector, double scale) {
        return Vectors.scale(vector, scale, null);
    }

    public static float[] scale(float[] vector, float scale) {
        return Vectors.scale(vector, scale, null);
    }

    public static double[] cross(double[] vector, double[] other) {
        return Vectors.cross(vector, other, null);
    }

    public static float[] cross(float[] vector, float[] other) {
        return Vectors.cross(vector, other, null);
    }

    public static double dot(double[] vector, double[] other) {
        double dot = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            dot += vector[i] * other[i];
        }
        return dot;
    }

    public static float dot(float[] vector, float[] other) {
        float dot = 0.0f;
        for (int i = 0; i < vector.length; ++i) {
            dot += vector[i] * other[i];
        }
        return dot;
    }

    public static double[] normalize(double[] vector) {
        return Vectors.normalize(vector, null);
    }

    public static float[] normalize(float[] vector) {
        return Vectors.normalize(vector, null);
    }

    public static double[] negate(double[] vector) {
        return Vectors.negate(vector, null);
    }

    public static float[] negate(float[] vector) {
        return Vectors.negate(vector, null);
    }

    public static float[] lerp(float[] start, float[] end, float ratio) {
        return Vectors.lerp(start, end, ratio, null);
    }

    public static double[] lerp(double[] start, double[] end, double ratio) {
        return Vectors.lerp(start, end, ratio, null);
    }

    public static double[] add(double[] vector, double[] other, double[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] + other[i];
        }
        return buffer;
    }

    public static float[] add(float[] vector, float[] other, float[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] + other[i];
        }
        return buffer;
    }

    public static double[] subtract(double[] vector, double[] other, double[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] - other[i];
        }
        return buffer;
    }

    public static float[] subtract(float[] vector, float[] other, float[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] - other[i];
        }
        return buffer;
    }

    public static double[] multiply(double[] vector, double[] other, double[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] * other[i];
        }
        return buffer;
    }

    public static float[] multiply(float[] vector, float[] other, float[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] * other[i];
        }
        return buffer;
    }

    public static double[] divide(double[] vector, double[] other, double[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] / other[i];
        }
        return buffer;
    }

    public static float[] divide(float[] vector, float[] other, float[] buffer) {
        if (vector.length != other.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] / other[i];
        }
        return buffer;
    }

    public static double[] scale(double[] vector, double scale, double[] buffer) {
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] * scale;
        }
        return buffer;
    }

    public static float[] scale(float[] vector, float scale, float[] buffer) {
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = vector[i] * scale;
        }
        return buffer;
    }

    public static double[] cross(double[] vector, double[] other, double[] buffer) {
        if (vector.length != 3 || other.length != 3) {
            throw new IllegalArgumentException("vector and v2 size must be 3.");
        }
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector and other.");
        }
        double newX = vector[1] * other[2] - vector[2] * other[1];
        double newY = vector[2] * other[0] - vector[0] * other[2];
        double newZ = vector[0] * other[1] - vector[1] * other[0];
        buffer[0] = newX;
        buffer[1] = newY;
        buffer[2] = newZ;
        return buffer;
    }

    public static float[] cross(float[] vector, float[] other, float[] buffer) {
        if (vector.length != 3 || other.length != 3) {
            throw new IllegalArgumentException("vector and other size must be 3.");
        }
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector and other.");
        }
        buffer[0] = vector[1] * other[2] - vector[2] * other[1];
        buffer[1] = vector[2] * other[0] - vector[0] * other[2];
        buffer[2] = vector[0] * other[1] - vector[1] * other[0];
        return buffer;
    }

    public static double[] normalize(double[] vector, double[] buffer) {
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        Vectors.scale(vector, 1.0 / Vectors.length(vector), buffer);
        return buffer;
    }

    public static float[] normalize(float[] vector, float[] buffer) {
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        Vectors.scale(vector, 1.0f / Vectors.length(vector), buffer);
        return buffer;
    }

    public static double[] negate(double[] vector, double[] buffer) {
        if (buffer == null) {
            buffer = new double[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = -vector[i];
        }
        return buffer;
    }

    public static float[] negate(float[] vector, float[] buffer) {
        if (buffer == null) {
            buffer = new float[vector.length];
        } else if (vector.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as vector.");
        }
        for (int i = 0; i < vector.length; ++i) {
            buffer[i] = -vector[i];
        }
        return buffer;
    }

    public static float[] lerp(float[] start, float[] end, float ratio, float[] buffer) {
        if (start.length != end.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new float[start.length];
        } else if (start.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as start and end vectors.");
        }
        for (int i = 0; i < start.length; ++i) {
            buffer[i] = (1.0f - ratio) * start[i] + ratio * end[i];
        }
        return buffer;
    }

    public static double[] lerp(double[] start, double[] end, double ratio, double[] buffer) {
        if (start.length != end.length) {
            throw new IllegalArgumentException("Both vectors must have same length.");
        }
        if (buffer == null) {
            buffer = new double[start.length];
        } else if (start.length != buffer.length) {
            throw new IllegalArgumentException("Buffer must have same length as start and end vectors.");
        }
        for (int i = 0; i < start.length; ++i) {
            buffer[i] = (1.0 - ratio) * start[i] + ratio * end[i];
        }
        return buffer;
    }

    public static double[] add(double[] source1, double[] source2, double[] buffer, int source1Offset, int source2Offset, int bufferOffset, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] + source2[source2Offset + i];
        }
        return buffer;
    }

    public static float[] add(float[] source1, float[] source2, float[] buffer, int source1Offset, int source2Offset, int bufferOffset, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] + source2[source2Offset + i];
        }
        return buffer;
    }

    public static double[] addRegular(double[] source1, double[] buffer, int source1Offset, int bufferOffset, double[] addition, int nbTuple) {
        int tupleSize = addition.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] + addition[i % tupleSize];
        }
        return buffer;
    }

    public static float[] addRegular(float[] source1, float[] buffer, int source1Offset, int bufferOffset, float[] addition, int nbTuple) {
        int tupleSize = addition.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] + addition[i % tupleSize];
        }
        return buffer;
    }

    public static double[] subtract(double[] source1, double[] source2, double[] buffer, int source1Offset, int source2Offset, int bufferOffset, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] - source2[source2Offset + i];
        }
        return buffer;
    }

    public static float[] subtract(float[] source1, float[] source2, float[] buffer, int source1Offset, int source2Offset, int bufferOffset, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] - source2[source2Offset + i];
        }
        return buffer;
    }

    public static double[] subtractRegular(double[] source1, double[] buffer, int source1Offset, int bufferOffset, double[] substraction, int nbTuple) {
        int tupleSize = substraction.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] - substraction[i % tupleSize];
        }
        return buffer;
    }

    public static float[] subtractRegular(float[] source1, float[] buffer, int source1Offset, int bufferOffset, float[] substraction, int nbTuple) {
        int tupleSize = substraction.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] - substraction[i % tupleSize];
        }
        return buffer;
    }

    public static double[] scaleRegular(double[] source1, double[] buffer, int source1Offset, int bufferOffset, double scale, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] * scale;
        }
        return buffer;
    }

    public static float[] scaleRegular(float[] source1, float[] buffer, int source1Offset, int bufferOffset, float scale, int tupleSize, int nbTuple) {
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] * scale;
        }
        return buffer;
    }

    public static double[] multiplyRegular(double[] source1, double[] buffer, int source1Offset, int bufferOffset, double[] scale, int nbTuple) {
        int tupleSize = scale.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] * scale[i % tupleSize];
        }
        return buffer;
    }

    public static float[] multiplyRegular(float[] source1, float[] buffer, int source1Offset, int bufferOffset, float[] scale, int nbTuple) {
        int tupleSize = scale.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] * scale[i % tupleSize];
        }
        return buffer;
    }

    public static double[] divideRegular(double[] source1, double[] buffer, int source1Offset, int bufferOffset, double[] scale, int nbTuple) {
        int tupleSize = scale.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] / scale[i % tupleSize];
        }
        return buffer;
    }

    public static float[] divideRegular(float[] source1, float[] buffer, int source1Offset, int bufferOffset, float[] scale, int nbTuple) {
        int tupleSize = scale.length;
        int n = nbTuple * tupleSize;
        for (int i = 0; i < n; ++i) {
            buffer[bufferOffset + i] = source1[source1Offset + i] / scale[i % tupleSize];
        }
        return buffer;
    }

    public static double[] cartesianToPolar(double[] cartesian) {
        if (cartesian.length != 2) {
            throw new IllegalArgumentException("cartesian.length must be 2({ x, y }).");
        }
        double r = Vectors.length(cartesian);
        double theta = Math.atan2(cartesian[1], cartesian[0]);
        return new double[]{r, theta};
    }

    public static float[] cartesianToPolar(float[] cartesian) {
        if (cartesian.length != 2) {
            throw new IllegalArgumentException("cartesian.length must be 2({ x, y }).");
        }
        float r = Vectors.length(cartesian);
        float theta = (float)Math.atan2(cartesian[1], cartesian[0]);
        return new float[]{r, theta};
    }

    public static double[] polarToCartesian(double[] polar) {
        if (polar.length != 2) {
            throw new IllegalArgumentException("polar.length must be 2({ r, theta }).");
        }
        double x = polar[0] * Math.cos(polar[1]);
        double y = polar[0] * Math.sin(polar[1]);
        return new double[]{x, y};
    }

    public static float[] polarToCartesian(float[] polar) {
        if (polar.length != 2) {
            throw new IllegalArgumentException("polar.length must be 2({ r, theta }).");
        }
        float x = polar[0] * (float)Math.cos(polar[1]);
        float y = polar[0] * (float)Math.sin(polar[1]);
        return new float[]{x, y};
    }

    public static double[] cartesianToCylindrical(double[] cartesian) {
        if (cartesian.length != 3) {
            throw new IllegalArgumentException("cartesian.length must be 3({ x, y, z }).");
        }
        double[] polar = Vectors.cartesianToPolar(new double[]{cartesian[0], cartesian[1]});
        double r = polar[0];
        double theta = polar[1];
        double h = cartesian[2];
        return new double[]{r, theta, h};
    }

    public static float[] cartesianToCylindrical(float[] cartesian) {
        if (cartesian.length != 3) {
            throw new IllegalArgumentException("cartesian.length must be 3({ x, y, z }).");
        }
        float[] polar = Vectors.cartesianToPolar(new float[]{cartesian[0], cartesian[1]});
        float r = polar[0];
        float theta = polar[1];
        float h = cartesian[2];
        return new float[]{r, theta, h};
    }

    public static double[] cylindricalToCartesian(double[] cylindrical) {
        if (cylindrical.length != 3) {
            throw new IllegalArgumentException("cartesian.length must be 3({ r, theta, z }).");
        }
        double x = cylindrical[0] * Math.cos(cylindrical[1]);
        double y = cylindrical[0] * Math.sin(cylindrical[1]);
        double z = cylindrical[2];
        return new double[]{x, y, z};
    }

    public static float[] cylindricalToCartesian(float[] cylindrical) {
        if (cylindrical.length != 3) {
            throw new IllegalArgumentException("cartesian.length must be 3({ r, theta, z }).");
        }
        float x = cylindrical[0] * (float)Math.cos(cylindrical[1]);
        float y = cylindrical[0] * (float)Math.sin(cylindrical[1]);
        float z = cylindrical[2];
        return new float[]{x, y, z};
    }

    public static double[] cartesianToSpherical(double[] cartesian) {
        if (cartesian.length != 3) {
            throw new IllegalArgumentException("cartesian.length must 3({ x, y, z }).");
        }
        double rho = Vectors.length(cartesian);
        double theta = Math.atan2(cartesian[1], cartesian[0]);
        double phi = Math.atan2(cartesian[2], Math.sqrt(cartesian[0] * cartesian[0] + cartesian[1] * cartesian[1]));
        return new double[]{rho, theta, phi};
    }

    public static float[] cartesianToSpherical(float[] cartesian) {
        if (cartesian.length != 3) {
            throw new IllegalArgumentException("cartesian.length must 3({ x, y, z }).");
        }
        float rho = Vectors.length(cartesian);
        float theta = (float)Math.atan2(cartesian[1], cartesian[0]);
        float phi = (float)Math.atan2(cartesian[2], Math.sqrt(cartesian[0] * cartesian[0] + cartesian[1] * cartesian[1]));
        return new float[]{rho, theta, phi};
    }

    public static double[] sphericalToCartesian(double[] spherical) {
        if (spherical.length != 3) {
            throw new IllegalArgumentException("cartesian.length must 3({ rho, theta, phi }).");
        }
        double rhoCosPhi = spherical[0] * Math.cos(spherical[2]);
        double x = rhoCosPhi * Math.cos(spherical[1]);
        double y = rhoCosPhi * Math.sin(spherical[1]);
        double z = spherical[0] * Math.sin(spherical[2]);
        return new double[]{x, y, z};
    }

    public static float[] sphericalToCartesian(float[] spherical) {
        if (spherical.length != 3) {
            throw new IllegalArgumentException("cartesian.length must 3({ rho, theta, phi }).");
        }
        float rhoCosPhi = spherical[0] * (float)Math.cos(spherical[2]);
        float x = rhoCosPhi * (float)Math.cos(spherical[1]);
        float y = rhoCosPhi * (float)Math.sin(spherical[1]);
        float z = spherical[0] * (float)Math.sin(spherical[2]);
        return new float[]{x, y, z};
    }
}

