/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

public enum DataType {
    BYTE,
    USHORT,
    SHORT,
    INT,
    FLOAT,
    DOUBLE;

    private static final DataType[] VALUES;

    public static DataType forBands(RenderedImage image) {
        return DataType.forDataBufferType(ImageUtilities.getBandType(image.getSampleModel()));
    }

    public static DataType forRange(NumberRange<?> range, boolean asInteger) {
        ArgumentChecks.ensureNonNull("range", range);
        byte nt = Numbers.getEnumConstant(range.getElementType());
        if (!asInteger) {
            if (nt >= 9) {
                return DOUBLE;
            }
            if (nt >= 7) {
                return FLOAT;
            }
        }
        double min = range.getMinDouble();
        double max = range.getMaxDouble();
        if (!(nt >= 3 && nt <= 8 && nt != 6 || min >= -1.67772165E7 && max < 1.67772165E7)) {
            return DOUBLE;
        }
        DataType type = min >= -0.5 && max < 65535.5 ? (max < 255.5 ? BYTE : USHORT) : (min >= -32768.5 && max < 32767.5 ? SHORT : (min >= -2.1474836485E9 && max < 2.1474836475E9 ? INT : FLOAT));
        return type;
    }

    public static DataType forPrimitiveType(Class<?> type, boolean unsigned) {
        switch (Numbers.getEnumConstant(type)) {
            case 3: {
                return unsigned ? BYTE : SHORT;
            }
            case 4: {
                return unsigned ? USHORT : SHORT;
            }
            case 5: {
                if (unsigned) break;
                return INT;
            }
            case 8: {
                return FLOAT;
            }
            case 9: {
                return DOUBLE;
            }
        }
        throw new RasterFormatException(Resources.format((short)69, type));
    }

    public static DataType forDataBufferType(int type) {
        if (type >= 0 && type < VALUES.length) {
            return VALUES[type];
        }
        throw new RasterFormatException(Resources.format((short)69, type));
    }

    public static DataType forNumberOfBits(int size, boolean real, boolean signed) {
        if (size < 1 || size > 64 || Integer.lowestOneBit(size) != size) {
            throw new RasterFormatException(Errors.format((short)45, "size", size));
        }
        String argument = "real";
        boolean value = real;
        if (real) {
            switch (size) {
                case 32: {
                    return FLOAT;
                }
                case 64: {
                    return DOUBLE;
                }
            }
        } else {
            boolean isInt;
            if (size == 16) {
                return signed ? SHORT : USHORT;
            }
            boolean bl = isInt = size == 32;
            if (isInt || size <= 8) {
                if (isInt == signed) {
                    return isInt ? INT : BYTE;
                }
                argument = "signed";
                value = signed;
            }
        }
        throw new RasterFormatException(Resources.format((short)78, size, argument, value));
    }

    public final int size() {
        return DataBuffer.getDataTypeSize(this.ordinal());
    }

    public final int bytes() {
        return Math.max(this.size() >>> 3, 1);
    }

    public final boolean isUnsigned() {
        return this.ordinal() <= 1;
    }

    public final boolean isInteger() {
        return this.ordinal() <= 3;
    }

    public final DataType toFloat() {
        int type = this.ordinal();
        return type < 3 || type == 4 ? FLOAT : DOUBLE;
    }

    public final int toDataBufferType() {
        return this.ordinal();
    }

    static {
        VALUES = DataType.values();
    }
}

