/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.DataOutput;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class URIDataStore
extends DataStore
implements StoreResource,
ResourceOnFileSystem {
    protected final URI location;
    private volatile Path locationAsPath;
    private final boolean locationIsPath;

    protected URIDataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.location = connector.getStorageAs(URI.class);
        Object storage = connector.getStorage();
        if (storage instanceof Path) {
            this.locationAsPath = (Path)storage;
        } else if (storage instanceof File) {
            this.locationAsPath = ((File)storage).toPath();
        }
        this.locationIsPath = this.locationAsPath != null;
    }

    @Override
    public final DataStore getOriginator() {
        return this;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        String filename = this.getFilename();
        return filename != null ? Optional.of(Names.createLocalName(null, null, (CharSequence)filename)) : super.getIdentifier();
    }

    private String getFilename() {
        if (this.location == null) {
            return null;
        }
        return IOUtilities.filenameWithoutExtension(this.location.isOpaque() ? this.location.getSchemeSpecificPart() : this.location.getPath());
    }

    protected final Path getSpecifiedPath() {
        return this.locationIsPath ? this.locationAsPath : null;
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        Path path = this.locationAsPath;
        if (path == null) {
            if (this.location == null) {
                return new Path[0];
            }
            try {
                path = Path.of(this.location);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException e) {
                throw new DataStoreException(e);
            }
            this.locationAsPath = path;
        }
        return new Path[]{path};
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public static ParameterValueGroup parameters(DataStoreProvider provider, URI location) {
        if (location == null || provider == null) {
            return null;
        }
        ParameterValueGroup pg = provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)location);
        return pg;
    }

    public static Object location(Resource resource) throws DataStoreException {
        Path[] paths;
        Optional<ParameterValueGroup> p;
        if (resource instanceof DataStore && (p = ((DataStore)resource).getOpenParameters()).isPresent()) {
            try {
                return p.get().parameter("location").getValue();
            }
            catch (ParameterNotFoundException e) {
                Logging.recoverableException(StoreUtilities.LOGGER, URIDataStore.class, "location", e);
            }
        }
        if (resource instanceof ResourceOnFileSystem && (paths = ((ResourceOnFileSystem)resource).getComponentFiles()) != null && paths.length != 0) {
            return paths[0];
        }
        return null;
    }

    protected final void addTitleOrIdentifier(MetadataBuilder builder) {
        String filename = this.getFilename();
        if (filename != null) {
            builder.addTitleOrIdentifier(filename, MetadataBuilder.Scope.ALL);
        }
    }

    public static abstract class Provider
    extends DataStoreProvider {
        public static final ParameterDescriptor<URI> LOCATION_PARAM;
        public static final ParameterDescriptor<Boolean> CREATE_PARAM;
        public static final ParameterDescriptor<Charset> ENCODING;
        private volatile ParameterDescriptorGroup openDescriptor;

        protected Provider() {
        }

        @Override
        public final ParameterDescriptorGroup getOpenParameters() {
            ParameterDescriptorGroup desc = this.openDescriptor;
            if (desc == null) {
                this.openDescriptor = desc = this.build((ParameterBuilder)new ParameterBuilder().addName((CharSequence)this.getShortName()));
            }
            return desc;
        }

        protected ParameterDescriptorGroup build(ParameterBuilder builder) {
            return builder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static ParameterDescriptorGroup descriptor(String name) {
            return ((ParameterBuilder)new ParameterBuilder().addName((CharSequence)name)).createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static StorageConnector connector(DataStoreProvider provider, ParameterValueGroup parameters) throws IllegalOpenParameterException {
            ParameterNotFoundException cause = null;
            if (parameters != null) {
                try {
                    Object location = parameters.parameter("location").getValue();
                    if (location != null) {
                        return new StorageConnector(location);
                    }
                }
                catch (ParameterNotFoundException e) {
                    cause = e;
                }
            }
            throw new IllegalOpenParameterException(Resources.format((short)27, provider.getShortName(), "location"), cause);
        }

        public static boolean isWritable(StorageConnector connector) throws DataStoreException {
            Object storage = connector.getStorage();
            if (storage instanceof OutputStream || storage instanceof DataOutput) {
                return true;
            }
            return ArraysExt.contains(connector.getOption(OptionKey.OPEN_OPTIONS), StandardOpenOption.WRITE);
        }

        static {
            ParameterBuilder builder = new ParameterBuilder();
            ENCODING = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"encoding")).setDescription((CharSequence)Resources.formatInternational((short)29))).create(Charset.class, null);
            CREATE_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"create")).setDescription((CharSequence)Resources.formatInternational((short)51))).create(Boolean.class, null);
            LOCATION_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"location")).setDescription((CharSequence)Resources.formatInternational((short)31))).setRequired(true).create(URI.class, null);
        }
    }
}

