/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.esri.AsciiGridStore;
import org.apache.sis.internal.storage.esri.CharactersView;
import org.apache.sis.internal.storage.esri.WritableStore;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

@StoreMetadata(formatName="ASCII Grid", fileSuffixes={"asc", "grd", "agr", "aig"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={GridCoverageResource.class})
public final class AsciiGridStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "ASCII Grid";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.esri");

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return this.probeContent(connector, ByteBuffer.class, buffer -> {
            block8: {
                buffer.mark();
                while (buffer.hasRemaining()) {
                    if (buffer.get() >= 0) continue;
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                buffer.reset();
                CharactersView view = new CharactersView(null, (ByteBuffer)buffer);
                try {
                    block9: {
                        Map<String, String> header = view.readHeader();
                        if (!header.containsKey("NROWS") || !header.containsKey("NCOLS") || !header.containsKey("XLLCORNER") && !header.containsKey("XLLCENTER") || !header.containsKey("YLLCORNER") && !header.containsKey("YLLCENTER")) break block8;
                        if (!header.containsKey("CELLSIZE")) {
                            int def = 0;
                            int i = 0;
                            while (i < AsciiGridStore.CELLSIZES.length) {
                                if (header.containsKey(AsciiGridStore.CELLSIZES[i++])) {
                                    def |= 1;
                                }
                                if (header.containsKey(AsciiGridStore.CELLSIZES[i++])) {
                                    def |= 2;
                                }
                                if (def != 3) continue;
                                break block9;
                            }
                            return ProbeResult.UNSUPPORTED_STORAGE;
                        }
                    }
                    return new ProbeResult(true, "text/plain", null);
                }
                catch (EOFException e) {
                    return ProbeResult.INSUFFICIENT_BYTES;
                }
                catch (DataStoreException dataStoreException) {
                    // empty catch block
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        });
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        if (AsciiGridStoreProvider.isWritable(connector)) {
            return new WritableStore(this, connector);
        }
        return new AsciiGridStore(this, connector, true);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }
}

