/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.MemoryGridResource;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.image.WritableResource;
import org.apache.sis.internal.storage.image.WritableStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.opengis.geometry.Envelope;

final class WritableSingleImageStore
extends WritableStore
implements WritableGridCoverageResource {
    private volatile WritableResource delegate;

    WritableSingleImageStore(FormatFinder format) throws DataStoreException, IOException {
        super(format);
    }

    @Override
    final boolean isComponentHidden() {
        return true;
    }

    final WritableResource delegate() throws DataStoreException {
        WritableResource r = this.delegate;
        if (r == null) {
            this.delegate = r = (WritableResource)((WorldFileStore.Components)this.components()).get(0);
        }
        return r;
    }

    @Override
    public final GridGeometry getGridGeometry() throws DataStoreException {
        return this.delegate().getGridGeometry();
    }

    @Override
    public final Optional<Envelope> getEnvelope() throws DataStoreException {
        return this.delegate().getEnvelope();
    }

    @Override
    public final List<double[]> getResolutions() throws DataStoreException {
        return this.delegate().getResolutions();
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.delegate().getSampleDimensions();
    }

    @Override
    public final GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        return this.delegate().subset(query);
    }

    @Override
    public final GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        return this.delegate().read(domain, ranges);
    }

    @Override
    public final RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.delegate().getLoadingStrategy();
    }

    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return this.delegate().setLoadingStrategy(strategy);
    }

    @Override
    public void write(GridCoverage coverage, WritableGridCoverageResource.Option ... options) throws DataStoreException {
        try {
            if (this.isMultiImages() == 0) {
                this.add(new MemoryGridResource(this.listeners, coverage, null));
            } else {
                this.delegate().write(coverage, options);
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
    }
}

