/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.ByteRangeChannel;
import org.apache.sis.internal.storage.io.ChannelData;
import org.apache.sis.internal.storage.io.DataTransfer;
import org.apache.sis.internal.storage.io.NullChannel;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class ChannelDataInput
extends ChannelData {
    private static final int SEEK_THRESHOLD = 8;
    public final ReadableByteChannel channel;

    public ChannelDataInput(String filename, ReadableByteChannel channel, ByteBuffer buffer, boolean filled) throws IOException {
        super(filename, channel, buffer);
        this.channel = channel;
        if (!filled) {
            buffer.clear();
            channel.read(buffer);
            buffer.flip();
        }
    }

    public ChannelDataInput(String filename, ByteBuffer data) {
        super(filename, data);
        this.channel = new NullChannel();
    }

    ChannelDataInput(ChannelDataInput input) {
        super(input);
        this.channel = input.channel;
    }

    public final long length() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            return Math.subtractExact(((SeekableByteChannel)this.channel).size(), this.channelOffset);
        }
        return -1L;
    }

    public final int prefetch() throws IOException {
        int capacity;
        int limit = this.buffer.limit();
        if (limit == (capacity = this.buffer.capacity())) {
            return -2;
        }
        int position = this.buffer.position();
        this.buffer.limit(capacity).position(limit);
        int c = this.channel.read(this.buffer);
        while (c == 0) {
            this.onEmptyTransfer();
            c = this.channel.read(this.buffer);
        }
        this.buffer.limit(this.buffer.position()).position(position);
        return c;
    }

    public final boolean hasRemaining() throws IOException {
        if (this.buffer.hasRemaining()) {
            return true;
        }
        this.bufferOffset += (long)this.buffer.limit();
        this.buffer.clear();
        int c = this.channel.read(this.buffer);
        while (c == 0) {
            this.onEmptyTransfer();
            c = this.channel.read(this.buffer);
        }
        this.buffer.flip();
        return c >= 0;
    }

    public final void ensureBufferContains(int n) throws EOFException, IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int c;
            this.bufferOffset += (long)this.buffer.position();
            this.buffer.compact();
            do {
                if ((c = this.channel.read(this.buffer)) > 0) continue;
                if (c != 0) {
                    throw new EOFException(this.eof());
                }
                this.onEmptyTransfer();
            } while ((n -= c) > 0);
            this.buffer.flip();
        }
    }

    private void ensureNonEmpty() throws IOException {
        if (!this.hasRemaining()) {
            throw new EOFException(this.eof());
        }
    }

    private String eof() {
        return Errors.format((short)137, this.filename);
    }

    final void pushBack() {
        this.buffer.position(this.buffer.position() - 1);
    }

    public final int readBit() throws IOException {
        this.ensureBufferContains(1);
        return this.readBitFromBuffer();
    }

    public final long readBits(int numBits) throws IOException {
        ArgumentChecks.ensureBetween("numBits", 0, 64, numBits);
        if (numBits == 0) {
            return 0L;
        }
        int bitOffset = this.getBitOffset();
        long value = this.readByte() & 255 >>> bitOffset;
        numBits -= 8 - bitOffset;
        while (numBits > 0) {
            value = value << 8 | (long)this.readUnsignedByte();
            numBits -= 8;
        }
        if (numBits != 0) {
            value >>>= -numBits;
            numBits += 8;
            this.pushBack();
        }
        this.setBitOffset(numBits);
        return value;
    }

    public final byte readByte() throws IOException {
        this.ensureBufferContains(1);
        return this.buffer.get();
    }

    public final int readUnsignedByte() throws IOException {
        return Byte.toUnsignedInt(this.readByte());
    }

    public final short readShort() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getShort();
    }

    public final int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    public final char readChar() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getChar();
    }

    public final int readInt() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getInt();
    }

    public final long readUnsignedInt() throws IOException {
        return Integer.toUnsignedLong(this.readInt());
    }

    public final long readLong() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getLong();
    }

    public final float readFloat() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getFloat();
    }

    public final double readDouble() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getDouble();
    }

    public final byte[] readBytes(int length) throws IOException {
        byte[] array = new byte[length];
        this.readFully(array);
        return array;
    }

    public final char[] readChars(int length) throws IOException {
        char[] array = new char[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final short[] readShorts(int length) throws IOException {
        short[] array = new short[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final int[] readInts(int length) throws IOException {
        int[] array = new int[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final long[] readLongs(int length) throws IOException {
        long[] array = new long[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final float[] readFloats(int length) throws IOException {
        float[] array = new float[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final double[] readDoubles(int length) throws IOException {
        double[] array = new double[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final void readFully(byte[] dest) throws IOException {
        this.readFully(dest, 0, dest.length);
    }

    public final void readFully(byte[] dest, int offset, int length) throws IOException {
        while (length != 0) {
            this.ensureNonEmpty();
            int n = Math.min(this.buffer.remaining(), length);
            this.buffer.get(dest, offset, n);
            offset += n;
            length -= n;
        }
    }

    public final void readFully(char[] dest, int offset, int length) throws IOException {
        new CharsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(short[] dest, int offset, int length) throws IOException {
        new ShortsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(int[] dest, int offset, int length) throws IOException {
        new IntsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(long[] dest, int offset, int length) throws IOException {
        new LongsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(float[] dest, int offset, int length) throws IOException {
        new FloatsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(double[] dest, int offset, int length) throws IOException {
        new DoublesReader(dest).readFully(null, offset, length);
    }

    public final String readString(int length, Charset encoding) throws IOException {
        byte[] array;
        int position;
        if (this.buffer.hasArray() && length <= this.buffer.capacity()) {
            this.ensureBufferContains(length);
            position = this.buffer.position();
            this.buffer.position(position + length);
            array = this.buffer.array();
            position += this.buffer.arrayOffset();
        } else {
            array = this.readBytes(length);
            position = 0;
        }
        while (length > 0 && array[position + (length - 1)] == 0) {
            --length;
        }
        return new String(array, position, length, encoding);
    }

    @Override
    public final void seek(long position) throws IOException {
        long p = Math.subtractExact(position, this.bufferOffset);
        if (p >= 0L && p <= (long)this.buffer.limit()) {
            this.buffer.position((int)p);
        } else if ((p < 0L || p - (long)this.buffer.limit() >= 8L) && this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).position(Math.addExact(this.channelOffset, position));
            this.bufferOffset = position;
            this.buffer.clear().limit(0);
        } else if (p >= 0L) {
            do {
                this.bufferOffset += (long)this.buffer.limit();
                p -= (long)this.buffer.limit();
                this.buffer.clear();
                int c = this.channel.read(this.buffer);
                if (c <= 0) {
                    if (c != 0) {
                        throw new EOFException(this.eof());
                    }
                    this.onEmptyTransfer();
                }
                this.buffer.flip();
            } while (p > (long)this.buffer.limit());
            this.buffer.position((int)p);
        } else {
            throw new InvalidSeekException(Resources.format((short)13, this.filename));
        }
        this.clearBitOffset();
    }

    public final void rangeOfInterest(long lower, long upper) {
        if (this.channel instanceof ByteRangeChannel) {
            lower = Math.addExact(lower, this.channelOffset);
            upper = Math.addExact(upper, this.channelOffset);
            ((ByteRangeChannel)this.channel).rangeOfInterest(lower, upper);
        }
    }

    public final boolean rewind() throws IOException {
        if (this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).position(this.channelOffset);
            this.buffer.clear().limit(0);
            this.bufferOffset = 0L;
            this.clearBitOffset();
            return true;
        }
        return false;
    }

    final class CharsReader
    extends ArrayReader {
        private CharBuffer view;
        private char[] dest;

        CharsReader(CharBuffer source) {
            this.view = source;
        }

        CharsReader(char[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 1;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return CharBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asCharBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new char[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (char[])array;
        }
    }

    final class ShortsReader
    extends ArrayReader {
        private ShortBuffer view;
        private short[] dest;

        ShortsReader(ShortBuffer source) {
            this.view = source;
        }

        ShortsReader(short[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 1;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return ShortBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asShortBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new short[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (short[])array;
        }
    }

    final class IntsReader
    extends ArrayReader {
        private IntBuffer view;
        private int[] dest;

        IntsReader(IntBuffer source) {
            this.view = source;
        }

        IntsReader(int[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 2;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return IntBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asIntBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new int[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (int[])array;
        }
    }

    final class LongsReader
    extends ArrayReader {
        private LongBuffer view;
        private long[] dest;

        LongsReader(LongBuffer source) {
            this.view = source;
        }

        LongsReader(long[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 3;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return LongBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asLongBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new long[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (long[])array;
        }
    }

    final class FloatsReader
    extends ArrayReader {
        private FloatBuffer view;
        private float[] dest;

        FloatsReader(FloatBuffer source) {
            this.view = source;
        }

        FloatsReader(float[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 2;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return FloatBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asFloatBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new float[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (float[])array;
        }
    }

    final class DoublesReader
    extends ArrayReader {
        private DoubleBuffer view;
        private double[] dest;

        DoublesReader(DoubleBuffer source) {
            this.view = source;
        }

        DoublesReader(double[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 3;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return DoubleBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return this.view;
        }

        @Override
        public Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asDoubleBuffer();
            return this.view;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new double[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (double[])array;
        }
    }

    final class BytesReader
    extends ArrayReader {
        private byte[] dest;

        BytesReader(byte[] dest) {
            this.dest = dest;
        }

        @Override
        public int dataSizeShift() {
            return 0;
        }

        @Override
        public Object dataArray() {
            return this.dest;
        }

        @Override
        public Buffer dataArrayAsBuffer() {
            return ByteBuffer.wrap(this.dest);
        }

        @Override
        public Buffer view() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        public Buffer createView() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        public void createDataArray(int n) {
            this.dest = new byte[n];
        }

        @Override
        void transfer(int p, int n) {
            ChannelDataInput.this.buffer.get(this.dest, p, n);
        }

        @Override
        public void setDest(Object array) {
            this.dest = (byte[])array;
        }

        @Override
        public void readFully(Buffer view, int offset, int length) throws IOException {
            ChannelDataInput.this.readFully(this.dest, offset, length);
        }
    }

    abstract class ArrayReader
    implements DataTransfer {
        ArrayReader() {
        }

        @Override
        public final String filename() {
            return ChannelDataInput.this.filename;
        }

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int n) {
            ChannelDataInput.this.buffer.position(ChannelDataInput.this.buffer.position() + n);
        }

        @Override
        public final void seek(long n) throws IOException {
            ChannelDataInput.this.seek(n);
        }

        @Override
        public void readFully(Buffer view, int offset, int length) throws IOException {
            int dataSizeShift = this.dataSizeShift();
            ChannelDataInput.this.ensureBufferContains(Math.min(length << dataSizeShift, ChannelDataInput.this.buffer.capacity()));
            if (view == null) {
                view = this.createView();
            } else {
                if ((ChannelDataInput.this.buffer.position() & (1 << dataSizeShift) - 1) != 0) {
                    ChannelDataInput.this.bufferOffset += (long)ChannelDataInput.this.buffer.position();
                    ChannelDataInput.this.buffer.compact().flip();
                }
                view.limit(ChannelDataInput.this.buffer.limit() >> dataSizeShift).position(ChannelDataInput.this.buffer.position() >> dataSizeShift);
            }
            int n = Math.min(view.remaining(), length);
            this.transfer(offset, n);
            this.skipInBuffer(n << dataSizeShift);
            while ((length -= n) != 0) {
                ChannelDataInput.this.ensureBufferContains(1 << dataSizeShift);
                view.rewind().limit(ChannelDataInput.this.buffer.remaining() >> dataSizeShift);
                n = Math.min(view.remaining(), length);
                this.transfer(offset += n, n);
                this.skipInBuffer(n << dataSizeShift);
            }
        }
    }
}

