/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.util.NamespaceBindings;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSClient;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class ETSAssert {
    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals((String)node.getLocalName(), (String)qName.getLocalPart(), (String)ErrorMessage.get("LocalName"));
        Assert.assertEquals((String)node.getNamespaceURI(), (String)qName.getNamespaceURI(), (String)ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            TestSuiteLogger.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathResult", context.getNodeName(), expr));
    }

    public static void assertXPath2(String expr, Source source, Map<String, String> namespaceBindings) {
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, "Asserting XPath expression {0} against {1} ({2})", new Object[]{expr, source.getClass().getName(), source.getSystemId()});
        }
        XdmValue result = null;
        try {
            result = XMLUtils.evaluateXPath2(source, expr, namespaceBindings);
        }
        catch (SaxonApiException e) {
            throw new AssertionError((Object)ErrorMessage.format("XPathError", expr + e.getMessage()));
        }
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("XPathResult", source.getSystemId(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator((Source)new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = validator.validate(xmlSource);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertFeatureAvailability(String id, boolean isAvailable, WFSClient wfsClient) {
        NodeList result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        Document rsp = wfsClient.invokeStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById", params);
        String xpath = String.format("/*[@gml:id = '%s']", id);
        try {
            result = XMLUtils.evaluateXPath(rsp, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        if (isAvailable && result.getLength() == 0) {
            throw new AssertionError((Object)ErrorMessage.format("FeatureAvailability", result.getLength(), id));
        }
        if (!isAvailable && result.getLength() > 0) {
            throw new AssertionError((Object)ErrorMessage.format("FeatureAvailability", result.getLength(), id));
        }
    }

    public static void assertFeatureProperties(String gmlId, Map<String, Object> properties, Map<String, String> nsBindings, WFSClient wfsClient) {
        Element feature;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", gmlId);
        Document rsp = wfsClient.invokeStoredQuery("urn:ogc:def:query:OGC-WFS::GetFeatureById", params);
        String xpath = String.format("//*[@gml:id = '%s']", gmlId);
        try {
            feature = (Element)XMLUtils.evaluateXPath(rsp, xpath, nsBindings).item(0);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)feature, (String)ErrorMessage.format("XPathResult", rsp.getDocumentElement().getNodeName(), xpath));
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String expr = null;
            if (Node.class.isInstance(property.getValue())) {
                Node value = (Node)property.getValue();
                expr = String.format("%s/%s", property.getKey(), value.getNodeName());
            } else {
                expr = String.format("%s = '%s'", property.getKey(), property.getValue().toString());
            }
            ETSAssert.assertXPath(expr, feature, nsBindings);
        }
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals((int)features.getLength(), (int)expectedCount, (String)String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertStatusCode(int actualCode, int[] expectedCodes) {
        Arrays.sort(expectedCodes);
        Assert.assertTrue((Arrays.binarySearch(expectedCodes, actualCode) >= 0 ? 1 : 0) != 0, (String)String.format("Expected status code(s) %s but received %d.", Arrays.toString(expectedCodes), actualCode));
    }

    public static void assertSimpleWFSCapabilities(Document doc) {
        ETSAssert.assertQualifiedName(doc.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "WFS_Capabilities"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", "SimpleWFSPhase");
        DOMResult result = validator.validate((Source)new DOMSource(doc, doc.getDocumentURI()));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }
}

