/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.TopologicalRelationships;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.TransformException;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BBOXOperatorTests
extends QueryFilterFixture {
    private static final String XSLT_ENV2POLYGON = "/org/opengis/cite/iso19142/util/bbox2polygon.xsl";
    private XSTypeDefinition gmlGeomBaseType;

    @BeforeClass
    public void createGeometryBaseType() {
        this.gmlGeomBaseType = this.model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
    }

    @Test(dataProvider="protocol-featureType")
    public void withBroadBBOXFilter(ProtocolBinding binding, QName featureType) {
        NodeList members;
        List<XSElementDeclaration> geomProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, this.gmlGeomBaseType);
        if (geomProps.isEmpty()) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getGeoExtent());
        this.addBBOXPredicate(this.reqEntity, gmlEnv.getDocumentElement(), null);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        String xpath = "//wfs:member/*";
        try {
            members = XMLUtils.evaluateXPath(this.rspEntity, xpath, nsBindings);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((members.getLength() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("XPathResult", this.rspEntity.getDocumentElement().getNodeName(), xpath));
        for (int i = 0; i < members.getLength(); ++i) {
            ETSAssert.assertQualifiedName(members.item(i), featureType);
        }
    }

    @Test(dataProvider="protocol-featureType")
    public void withBBOXFilter(ProtocolBinding binding, QName featureType) {
        NodeList geometryNodes;
        String xpath;
        List<XSElementDeclaration> geomProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, this.gmlGeomBaseType);
        if (geomProps.isEmpty()) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        XSElementDeclaration geomProp = geomProps.get(0);
        Element valueRef = WFSRequest.createValueReference(geomProp);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getGeoExtent());
        this.addBBOXPredicate(this.reqEntity, gmlEnv.getDocumentElement(), valueRef);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(featureType.getNamespaceURI(), "ns1");
        if (!geomProp.getNamespace().equals(featureType.getNamespaceURI())) {
            nsBindings.put(geomProp.getNamespace(), "ns2");
            xpath = String.format("//ns1:%s/ns2:%s/*[1]", featureType.getLocalPart(), geomProp.getName());
        } else {
            xpath = String.format("//ns1:%s/ns1:%s/*[1]", featureType.getLocalPart(), geomProp.getName());
        }
        try {
            geometryNodes = XMLUtils.evaluateXPath(this.rspEntity, xpath, nsBindings);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((geometryNodes.getLength() > 0 ? 1 : 0) != 0, (String)ErrorMessage.format("XPathResult", this.rspEntity.getDocumentElement().getNodeName(), xpath));
        Document gmlPolygon = XMLUtils.transform(new StreamSource(this.getClass().getResourceAsStream(XSLT_ENV2POLYGON)), gmlEnv);
        for (int i = 0; i < geometryNodes.getLength(); ++i) {
            Element geometry = (Element)geometryNodes.item(i);
            if (geometry.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "PolygonPatch").getLength() > 0) {
                geometry = this.surfaceToPolygon(geometry);
            }
            try {
                boolean intersects = TopologicalRelationships.intersects((Node)gmlPolygon.getDocumentElement(), (Node)geometry);
                Assert.assertTrue((boolean)intersects, (String)ErrorMessage.format("PredicateNotSatisfied", "BBOX", XMLUtils.writeNodeToString(gmlPolygon), XMLUtils.writeNodeToString(geometry)));
                continue;
            }
            catch (TransformException te) {
                throw new RuntimeException("Coordinate transformation failed.", te);
            }
        }
    }

    @Test(dataProvider="instantiated-feature-types")
    public void invalidGeometryOperand(QName featureType) {
        XSElementDeclaration gmlDesc = this.model.getElementDeclaration("description", "http://www.opengis.net/gml/3.2");
        Element valueRef = WFSRequest.createValueReference(gmlDesc);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getGeoExtent());
        this.addBBOXPredicate(this.reqEntity, gmlEnv.getDocumentElement(), valueRef);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        String xpath = "//ows:Exception[@exceptionCode='InvalidParameterValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity, null);
    }

    Element surfaceToPolygon(Element geometry) {
        Document result = XMLUtils.transform(new StreamSource(this.getClass().getResourceAsStream("surface2polygon.xsl")), geometry);
        return result.getDocumentElement();
    }

    void addBBOXPredicate(Document request, Element envelope, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element bbox = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:BBOX");
        filter.appendChild(bbox);
        if (null != valueRef) {
            bbox.appendChild(request.importNode(valueRef, true));
        }
        bbox.appendChild(request.importNode(envelope, true));
    }
}

