/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceIdOperatorTests
extends QueryFilterFixture {
    @Test(dataProvider="protocol-featureType")
    public void twoValidFeatureIdentifiers(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Set<String> idSet = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 2);
        this.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        ETSAssert.assertDescendantElementCount(this.rspEntity, featureType, idSet.size());
    }

    @Test(dataProvider="protocol-featureType")
    public void unknownFeatureIdentifier(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("test-" + UUID.randomUUID());
        this.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        ETSAssert.assertDescendantElementCount(this.rspEntity, featureType, 0);
    }

    void addResourceIdPredicate(Document request, Set<String> idSet) {
        if (idSet.isEmpty()) {
            return;
        }
        NodeList queryList = request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query");
        if (queryList.getLength() == 0) {
            throw new IllegalArgumentException("No wfs:Query element found in request: " + request.getDocumentElement().getNodeName());
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryList.item(0).appendChild(filter);
        for (String id : idSet) {
            Element resourceId = request.createElementNS("http://www.opengis.net/fes/2.0", "ResourceId");
            resourceId.setAttribute("rid", id);
            filter.appendChild(resourceId);
        }
    }
}

