/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.locking;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.locking.LockFeatureTests;
import org.opengis.cite.iso19142.locking.LockingFixture;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetFeatureWithLockTests
extends LockingFixture {
    @BeforeClass(alwaysRun=true)
    public void sutImplementsGetFeatureWithLock(ITestContext testContext) {
        String xpath = String.format("//ows:Operation[@name='%s']", "GetFeatureWithLock");
        ETSAssert.assertXPath(xpath, this.wfsMetadata, null);
    }

    @BeforeMethod
    public void buildGetFeatureWithLockRequest() {
        this.reqEntity = WFSRequest.createRequestEntity("GetFeatureWithLock");
    }

    @Test
    public void lockQueryResults_hits() {
        QName featureType = LockFeatureTests.selectRandomFeatureType(this.featureInfo);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        this.reqEntity.getDocumentElement().setAttribute("resultType", "hits");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'InvalidParameterValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test
    public void lockAllQueryResults_20Seconds() {
        QName featureType = LockFeatureTests.selectRandomFeatureType(this.featureInfo);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        this.reqEntity.getDocumentElement().setAttribute("expiry", "20");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element featureColl = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureCollection").item(0);
        String lockId = featureColl.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId"));
        this.locks.add(lockId);
        try {
            Thread.sleep(34000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.reqEntity = WFSRequest.createRequestEntity("LockFeature");
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureByType", Collections.singletonMap("typeName", featureType));
        this.reqEntity.getDocumentElement().setAttribute("lockId", lockId);
        rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'LockHasExpired']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test
    public void lockSomeQueryResults() {
        QName featureType1 = LockFeatureTests.selectRandomFeatureType(this.featureInfo);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType1);
        this.reqEntity.getDocumentElement().setAttribute("expiry", "60");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element featureColl = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureCollection").item(0);
        String lockId = featureColl.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId in response to GetFeatureWithLock"));
        this.locks.add(lockId);
        QName featureType2 = LockFeatureTests.selectRandomFeatureType(this.featureInfo);
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType2);
        this.reqEntity.getDocumentElement().setAttribute("lockAction", "SOME");
        rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        featureColl = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureCollection").item(0);
        lockId = featureColl.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId in response to GetFeatureWithLock"));
        this.locks.add(lockId);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(featureType1.getNamespaceURI(), "ns1");
        String xpath1 = String.format("not(//ns1:%s)", featureType1.getLocalPart());
        ETSAssert.assertXPath(xpath1, this.rspEntity.getDocumentElement(), nsBindings);
        nsBindings.put(featureType2.getNamespaceURI(), "ns2");
        String xpath2 = String.format("//ns2:%s", featureType2.getLocalPart());
        ETSAssert.assertXPath(xpath2, this.rspEntity.getDocumentElement(), nsBindings);
    }
}

