/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.WFSClient;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.Reporter;
import org.testng.annotations.BeforeSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Prerequisites {
    private static final Logger LOGR = Logger.getLogger(Prerequisites.class.getName());

    @BeforeSuite(alwaysRun=true)
    public void verifyServiceDescription(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        ETSAssert.assertSimpleWFSCapabilities(wfsMetadata);
    }

    @BeforeSuite(dependsOnMethods={"verifyServiceDescription"})
    public void serviceIsAvailable(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WFSClient wfsClient = new WFSClient(wfsMetadata);
        Document capabilities = wfsClient.getCapabilities();
        Assert.assertNotNull((Object)capabilities, (String)"No GetCapabilities response from SUT.");
        Element docElement = capabilities.getDocumentElement();
        Assert.assertEquals((String)docElement.getLocalName(), (String)"WFS_Capabilities", (String)"Capabilities document element has unexpected [local name].");
        Assert.assertEquals((String)docElement.getNamespaceURI(), (String)"http://www.opengis.net/wfs/2.0", (String)"Capabilities document element has unexpected [namespace name].");
    }

    @BeforeSuite(dependsOnMethods={"verifyServiceDescription"})
    public void dataAreAvailable(ITestContext testContext) throws Exception {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        DataSampler sampler = new DataSampler(wfsMetadata);
        sampler.acquireFeatureData();
        Map<QName, FeatureTypeInfo> featureTypeInfo = sampler.getFeatureTypeInfo();
        boolean sutHasData = false;
        for (FeatureTypeInfo typeInfo : featureTypeInfo.values()) {
            if (!typeInfo.isInstantiated()) continue;
            sutHasData = true;
            break;
        }
        if (!sutHasData) {
            String msg = ErrorMessage.get("DataNotAvailable");
            LOGR.warning(msg + featureTypeInfo.toString());
            Reporter.getOutput().add(msg);
            throw new AssertionError((Object)msg);
        }
    }
}

