/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.awt.RenderingHints;
import java.sql.Connection;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.testng.IExecutionListener;

public class TestRunListener
implements IExecutionListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionStart() {
        DataSource epsgDataSource = null;
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:/comp/env");
            epsgDataSource = (DataSource)envContext.lookup("jdbc/EPSG");
        }
        catch (NamingException nx) {
            TestSuiteLogger.log(Level.CONFIG, "DataSource 'jdbc/EPSG' was not found. An embedded database will be created if necessary.");
        }
        if (null != epsgDataSource) {
            Connection conn = null;
            try {
                conn = epsgDataSource.getConnection();
                EpsgInstaller dbInstaller = new EpsgInstaller();
                dbInstaller.setDatabase(conn);
                try {
                    if (!dbInstaller.exists()) {
                        dbInstaller.call();
                    }
                }
                finally {
                    conn.close();
                }
            }
            catch (Exception e) {
                TestSuiteLogger.log(Level.CONFIG, "Failed to access DataSource 'jdbc/EPSG'\n." + e.getMessage());
            }
            Hints.putSystemDefault((RenderingHints.Key)Hints.EPSG_DATA_SOURCE, (Object)epsgDataSource);
        }
    }

    public void onExecutionFinish() {
    }
}

