/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceIdOperatorTests
extends QueryFilterFixture {
    @Test(dataProvider="protocol-featureType")
    public void twoValidFeatureIdentifiers(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Set<String> idSet = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 2);
        WFSRequest.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        ETSAssert.assertDescendantElementCount(this.rspEntity, featureType, idSet.size());
    }

    @Test(dataProvider="protocol-featureType")
    public void unknownFeatureIdentifier(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("test-" + UUID.randomUUID());
        WFSRequest.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        ETSAssert.assertDescendantElementCount(this.rspEntity, featureType, 0);
    }

    public void inconsistentFeatureIdentifierAndType(ProtocolBinding binding, QName featureType) {
    }
}

