/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.transaction.TransactionFixture;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeleteTests
extends TransactionFixture {
    private List<Element> deletedFeatures = new ArrayList<Element>();

    @AfterClass
    public void restoreDeletedFeatures() {
        Boolean result;
        if (this.deletedFeatures.isEmpty()) {
            return;
        }
        Document rspEntity = this.wfsClient.insert(this.deletedFeatures, ProtocolBinding.ANY);
        String xpath = String.format("//wfs:totalInserted = '%d'", this.deletedFeatures.size());
        try {
            result = (Boolean)XMLUtils.evaluateXPath(rspEntity, xpath, null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!result.booleanValue()) {
            String msg = String.format("%s: Failed to insert deleted features.\n%s", this.getClass().getName(), XMLUtils.writeNodeToString(rspEntity));
            TestSuiteLogger.log(Level.WARNING, msg);
        }
    }

    @Test(dataProvider="binding+availFeatureType")
    public void deleteFeature(ProtocolBinding binding, QName featureType) {
        Document doc = this.wfsClient.getFeatureByType(featureType, 10, null);
        NodeList features = doc.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        Random random = new Random();
        Element originalFeature = (Element)features.item(random.nextInt(features.getLength()));
        String gmlId = originalFeature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
        HashMap<String, QName> featuresToDelete = new HashMap<String, QName>();
        featuresToDelete.put(gmlId, new QName(originalFeature.getNamespaceURI(), originalFeature.getLocalName()));
        this.rspEntity = this.wfsClient.delete(featuresToDelete, binding);
        ETSAssert.assertXPath("//wfs:TransactionResponse", this.rspEntity, null);
        String xpath = String.format("//wfs:totalDeleted = '%d'", featuresToDelete.size());
        ETSAssert.assertXPath(xpath, this.rspEntity, null);
        this.deletedFeatures.add(originalFeature);
        ETSAssert.assertFeatureAvailability(gmlId, false, this.wfsClient);
    }
}

