/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.transaction.TransactionFixture;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertTests
extends TransactionFixture {
    private Map<String, QName> createdFeatures = new HashMap<String, QName>();

    @AfterClass
    public void removeNewFeatures() {
        Boolean result;
        if (this.createdFeatures.isEmpty()) {
            return;
        }
        Document rspEntity = this.wfsClient.delete(this.createdFeatures, ProtocolBinding.ANY);
        String xpath = String.format("//wfs:totalDeleted = '%d'", this.createdFeatures.size());
        try {
            result = (Boolean)XMLUtils.evaluateXPath(rspEntity, xpath, null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!result.booleanValue()) {
            String msg = String.format("%s: Failed to remove all new features:\n %s \n%s", this.getClass().getName(), this.createdFeatures, XMLUtils.writeNodeToString(rspEntity));
            TestSuiteLogger.log(Level.WARNING, msg);
        }
    }

    @Test(dataProvider="binding+availFeatureType")
    public void insertSupportedFeature(ProtocolBinding binding, QName featureType) {
        Node feature = this.createFeatureInstance(featureType);
        WFSRequest.addInsertStatement(this.reqEntity, feature);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertXPath("//wfs:TransactionResponse/wfs:InsertResults", this.rspEntity, null);
        List<String> newFeatureIDs = this.extractFeatureIdentifiers(this.rspEntity);
        String id = newFeatureIDs.get(0);
        this.createdFeatures.put(id, featureType);
        ETSAssert.assertFeatureAvailability(id, true, this.wfsClient);
    }

    @Test
    public void insertInvalidFeature() {
        try {
            this.reqEntity = this.docBuilder.parse(this.getClass().getResourceAsStream("InsertUnrecognizedFeature.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse InsertUnrecognizedFeature.xml from classpath", e);
        }
        ProtocolBinding binding = this.wfsClient.getAnyTransactionBinding();
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        String xpath = "//ows:Exception[@exceptionCode = 'InvalidValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    List<String> extractFeatureIdentifiers(Document entity) {
        ArrayList<String> resourceIDs = new ArrayList<String>();
        String xpath = "//wfs:InsertResults/wfs:Feature/fes:ResourceId/@rid";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        nsBindings.put("http://www.opengis.net/fes/2.0", "fes");
        try {
            NodeList ridNodes = XMLUtils.evaluateXPath(entity, xpath, nsBindings);
            for (int i = 0; i < ridNodes.getLength(); ++i) {
                resourceIDs.add(ridNodes.item(i).getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return resourceIDs;
    }

    Node createFeatureInstance(QName featureType) {
        Document entity = this.wfsClient.getFeatureByType(featureType, 1, null);
        NodeList features = entity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        if (features.getLength() == 0) {
            throw new NullPointerException("Unable to obtain feature instance of type " + featureType);
        }
        Element feature = (Element)features.item(0);
        feature.setAttributeNS("http://www.opengis.net/gml/3.2", "gml:id", "id-" + System.currentTimeMillis());
        this.insertRandomIdentifier(feature);
        return feature.cloneNode(true);
    }

    void insertRandomIdentifier(Element feature) {
        QName propName = new QName("http://www.opengis.net/gml/3.2", "identifier");
        Element identifier = XMLUtils.createElement(propName);
        identifier.setAttribute("codeSpace", "http://cite.opengeospatial.org/");
        identifier.setTextContent(UUID.randomUUID().toString());
        WFSRequest.insertGMLProperty(feature, identifier);
    }
}

