/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTests
extends BaseFixture {
    @BeforeClass
    public void buildRequestEntity() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.reqEntity = builder.parse(this.getClass().getResourceAsStream("DescribeFeatureType.xml"));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse request entity from classpath", e);
        }
    }

    @BeforeMethod
    public void clearTypeNames() {
        this.removeAllTypeNames(this.reqEntity);
    }

    void removeAllTypeNames(Document reqEntity) {
        Element docElem = reqEntity.getDocumentElement();
        NodeList children = docElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            docElem.removeChild(children.item(i));
        }
    }

    void addFeatureType(Document request, QName qName) {
        Element docElem = request.getDocumentElement();
        Element typeName = request.createElementNS("http://www.opengis.net/wfs/2.0", "TypeName");
        String nsPrefix = docElem.lookupPrefix(qName.getNamespaceURI());
        if (null == nsPrefix) {
            nsPrefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
        }
        typeName.setTextContent(nsPrefix + ":" + qName.getLocalPart());
        typeName.setPrefix("wfs");
        docElem.appendChild(typeName);
        docElem.setAttribute("xmlns:" + nsPrefix, qName.getNamespaceURI());
    }

    @Test(description="See ISO 19142: 9.2.4.1", dataProvider="protocol-binding")
    public void describeAllFeatureTypes(ProtocolBinding binding) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DescribeFeatureType", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Element docElem = this.rspEntity.getDocumentElement();
        Assert.assertEquals((String)docElem.getLocalName(), (String)"schema", (String)"Document element has unexpected [local name].");
    }

    @Test(description="See ISO 19142: 8.3.4, 9.2.4.1", dataProvider="protocol-binding")
    public void describeUnknownFeatureType(ProtocolBinding binding) {
        this.addFeatureType(this.reqEntity, new QName("http://example.org", "Unknown1.Type"));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DescribeFeatureType", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "InvalidParameterValuePhase");
        DOMResult result = validator.validate((Source)new DOMSource(this.rspEntity));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }
}

