/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.apidescription;

import com.reprezen.kaizen.oasparser.OpenApi3Parser;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.opengis.cite.wfs30.CommonFixture;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class OpenApi
extends CommonFixture {
    private String response;
    private String apiUrl;

    @BeforeClass(dependsOnMethods={"initCommonFixture"})
    public void retrieveApiUrl() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        JsonPath jsonPath = request.jsonPath();
        this.apiUrl = this.parseApiUrl(jsonPath);
    }

    @Test(description="Implements A.4.2.3. OpenAPI Document Retrieval (Requirement 3, 4)", groups={"apidefinition"}, dependsOnGroups={"landingpage"})
    public void openapiDocumentRetrieval() {
        if (this.apiUrl == null || this.apiUrl.isEmpty()) {
            throw new SkipException("Api URL could not be parsed from the landing page");
        }
        Response request = (Response)this.init().baseUri(this.apiUrl).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.asString();
    }

    @Test(description="Implements A.4.2.4. API Definition Validation (Requirement 4)", groups={"apidefinition"}, dependsOnMethods={"openapiDocumentRetrieval"})
    public void apiDefinitionValidation(ITestContext testContext) throws MalformedURLException {
        OpenApi3Parser parser = new OpenApi3Parser();
        OpenApi3 apiModel = parser.parse(this.response, new URL(this.apiUrl), true);
        Assert.assertTrue((boolean)apiModel.isValid(), (String)this.createValidationMsg(apiModel));
        testContext.getSuite().setAttribute(SuiteAttribute.API_MODEL.getName(), (Object)apiModel);
    }

    private String parseApiUrl(JsonPath jsonPath) {
        for (Object link : jsonPath.getList("links")) {
            Map linkMap = (Map)link;
            Object rel = linkMap.get("rel");
            Object type = linkMap.get("type");
            if (!"service".equals(rel) || !"application/openapi+json;version=3.0".equals(type)) continue;
            return (String)linkMap.get("href");
        }
        return null;
    }

    private String createValidationMsg(OpenApi3 model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Landing Page is not valid. Found following validation items:");
        if (!model.isValid()) {
            for (ValidationResults.ValidationItem item : model.getValidationItems()) {
                sb.append("  - ").append(item.getSeverity()).append(": ").append(item.getMsg());
            }
        }
        return sb.toString();
    }
}

