/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.openapi3;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Response;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.model3.Server;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.wfs30.WFS3;
import org.opengis.cite.wfs30.openapi3.TestPoint;

public class OpenApiUtils {
    private static final String DEFAULT_SERVER_URL = "/";

    private OpenApiUtils() {
    }

    public static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel) {
        List<Path> pathItemObjects = OpenApiUtils.identifyTestPoints(apiModel);
        List<PathItemAndServer> pathItemAndServers = OpenApiUtils.identifyServerUrls(apiModel, pathItemObjects);
        return OpenApiUtils.processServerObjects(pathItemAndServers);
    }

    public static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, WFS3.PATH path) {
        return OpenApiUtils.retrieveTestPoints(apiModel, path, null);
    }

    public static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, WFS3.PATH path, String extendedPath) {
        StringBuilder requestedPath = new StringBuilder();
        requestedPath.append(path.getPathItem());
        if (extendedPath != null) {
            if (!extendedPath.startsWith(DEFAULT_SERVER_URL)) {
                requestedPath.append(DEFAULT_SERVER_URL);
            }
            requestedPath.append(extendedPath);
        }
        List<Path> pathItemObjects = OpenApiUtils.identifyTestPoints(apiModel, requestedPath.toString());
        List<PathItemAndServer> pathItemAndServers = OpenApiUtils.identifyServerUrls(apiModel, pathItemObjects);
        return OpenApiUtils.processServerObjects(pathItemAndServers);
    }

    private static List<Path> identifyTestPoints(OpenApi3 apiModel) {
        ArrayList<String> paths = new ArrayList<String>();
        for (WFS3.PATH path : WFS3.PATH.values()) {
            paths.add(path.getPathItem());
        }
        return OpenApiUtils.identifyTestPoints(apiModel, paths);
    }

    private static List<Path> identifyTestPoints(OpenApi3 apiModel, String path) {
        return OpenApiUtils.identifyTestPoints(apiModel, Collections.singletonList(path));
    }

    private static List<Path> identifyTestPoints(OpenApi3 apiModel, List<String> path) {
        ArrayList<Path> pathItems = new ArrayList<Path>();
        Map pathItemObjects = apiModel.getPaths();
        for (Path pathItemObject : pathItemObjects.values()) {
            String pathString = pathItemObject.getPathString();
            if (!OpenApiUtils.isRequestedPath(pathString, path)) continue;
            pathItems.add(pathItemObject);
        }
        return pathItems;
    }

    private static boolean isRequestedPath(String pathString, List<String> path) {
        for (String pathRequested : path) {
            if (!pathString.matches("\\/" + pathRequested + "(\\/?)")) continue;
            return true;
        }
        return false;
    }

    private static List<PathItemAndServer> identifyServerUrls(OpenApi3 apiModel, List<Path> pathItemObjects) {
        ArrayList<PathItemAndServer> pathItemAndServers = new ArrayList<PathItemAndServer>();
        for (Path pathItemObject : pathItemObjects) {
            Map operationObjects = pathItemObject.getOperations();
            for (Operation operationObject : operationObjects.values()) {
                List<String> serverUrls = OpenApiUtils.identifyServerObjects(apiModel, pathItemObject, operationObject);
                for (String serverUrl : serverUrls) {
                    PathItemAndServer pathItemAndServer = new PathItemAndServer(pathItemObject, operationObject, serverUrl);
                    pathItemAndServers.add(pathItemAndServer);
                }
            }
        }
        return pathItemAndServers;
    }

    private static List<TestPoint> processServerObjects(List<PathItemAndServer> pathItemAndServers) {
        ArrayList<TestPoint> uris = new ArrayList<TestPoint>();
        for (PathItemAndServer pathItemAndServer : pathItemAndServers) {
            OpenApiUtils.processServerObject(uris, pathItemAndServer);
        }
        return uris;
    }

    private static void processServerObject(List<TestPoint> uris, PathItemAndServer pathItemAndServer) {
        String pathString = pathItemAndServer.pathItemObject.getPathString();
        UriTemplate uriTemplate = new UriTemplate(pathItemAndServer.serverUrl + pathString);
        Response response = pathItemAndServer.operationObject.getResponse("200");
        Map contentMediaTypes = response.getContentMediaTypes();
        if (uriTemplate.getNumberOfTemplateVariables() == 0) {
            TestPoint testPoint = new TestPoint(uriTemplate, contentMediaTypes);
            uris.add(testPoint);
        } else {
            List<Map<String, String>> templateReplacements = OpenApiUtils.collectTemplateReplacements(pathItemAndServer, uriTemplate);
            if (templateReplacements.isEmpty()) {
                TestPoint testPoint = new TestPoint(uriTemplate, contentMediaTypes);
                uris.add(testPoint);
            } else {
                for (Map<String, String> templateReplacement : templateReplacements) {
                    TestPoint testPoint = new TestPoint(uriTemplate, templateReplacement, contentMediaTypes);
                    uris.add(testPoint);
                }
            }
        }
    }

    private static List<Map<String, String>> collectTemplateReplacements(PathItemAndServer pathItemAndServer, UriTemplate uriTemplate) {
        ArrayList<Map<String, String>> templateReplacements = new ArrayList<Map<String, String>>();
        Collection parameters = pathItemAndServer.operationObject.getParameters();
        for (String templateVariable : uriTemplate.getTemplateVariables()) {
            for (Parameter parameter : parameters) {
                if (!templateVariable.equals(parameter.getName())) continue;
                Schema schema = parameter.getSchema();
                if (schema.hasEnums()) {
                    OpenApiUtils.addEnumTemplateValues(templateReplacements, templateVariable, schema);
                    continue;
                }
                if (schema.getDefault() == null) continue;
                OpenApiUtils.addDefaultTemplateValue(templateReplacements, templateVariable, schema);
            }
        }
        return templateReplacements;
    }

    private static void addEnumTemplateValues(List<Map<String, String>> templateReplacements, String templateVariable, Schema schema) {
        Collection enums = schema.getEnums();
        if (enums.size() == 1) {
            for (Object enumValue : enums) {
                HashMap<String, String> replacement = new HashMap<String, String>();
                replacement.put(templateVariable, enumValue.toString());
                templateReplacements.add(replacement);
            }
        } else {
            ArrayList templateReplacementsToAdd = new ArrayList();
            for (Map<String, String> templateReplacement : templateReplacements) {
                for (Object enumValue : enums) {
                    HashMap<String, String> newTemplateReplacement = new HashMap<String, String>();
                    newTemplateReplacement.putAll(templateReplacement);
                    newTemplateReplacement.put(templateVariable, enumValue.toString());
                    templateReplacementsToAdd.add(newTemplateReplacement);
                }
            }
            templateReplacements.clear();
            templateReplacements.addAll(templateReplacementsToAdd);
        }
    }

    private static void addDefaultTemplateValue(List<Map<String, String>> templateReplacements, String templateVariable, Schema schema) {
        if (templateReplacements.isEmpty()) {
            HashMap replacement = new HashMap();
            templateReplacements.add(replacement);
        }
        for (Map<String, String> templateReplacement : templateReplacements) {
            templateReplacement.put(templateVariable, schema.getDefault().toString());
        }
    }

    private static List<String> identifyServerObjects(OpenApi3 apiModel, Path pathItemObject, Operation operationObject) {
        if (operationObject.hasServers()) {
            return OpenApiUtils.parseUrls(operationObject.getServers());
        }
        if (pathItemObject.hasServers()) {
            return OpenApiUtils.parseUrls(pathItemObject.getServers());
        }
        if (apiModel.hasServers()) {
            return OpenApiUtils.parseUrls(apiModel.getServers());
        }
        return Collections.singletonList(DEFAULT_SERVER_URL);
    }

    private static List<String> parseUrls(Collection<Server> servers) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Server server : servers) {
            urls.add(server.getUrl());
        }
        return urls;
    }

    private static class PathItemAndServer {
        private final Path pathItemObject;
        private Operation operationObject;
        private String serverUrl;

        private PathItemAndServer(Path pathItemObject, Operation operationObject, String serverUrl) {
            this.pathItemObject = pathItemObject;
            this.operationObject = operationObject;
            this.serverUrl = serverUrl;
        }
    }
}

