/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public class BooleanOverlay
extends ScalarOverlay<Boolean> {
    public static OverlayFactory<Boolean> factory = new OverlayFactory<Boolean>(){

        @Override
        protected Class<BooleanOverlay> getOverlayClass() {
            return BooleanOverlay.class;
        }

        public BooleanOverlay _create(Boolean value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new BooleanOverlay(value, parent, refReg);
        }

        public BooleanOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new BooleanOverlay(json, parent, refReg);
        }
    };

    private BooleanOverlay(Boolean value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    private BooleanOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    @Override
    public Boolean fromJson(JsonNode json) {
        return json.isBoolean() ? Boolean.valueOf(json.booleanValue()) : null;
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? BooleanOverlay.jsonBoolean((Boolean)this.value) : BooleanOverlay.jsonMissing();
    }
}

