/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.ChildOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import java.util.Map;
import java.util.regex.Pattern;

public class ChildMapOverlay<V>
extends ChildOverlay<Map<String, V>> {
    private MapOverlay<V> mapOverlay;

    public ChildMapOverlay(String path, JsonNode json, JsonOverlay<?> parent, OverlayFactory<Map<String, V>> factory, ReferenceRegistry refReg) {
        super(path, json, parent, factory, refReg, ((MapOverlay.MapOverlayFactory)factory).getKeyPattern() == null);
        this.mapOverlay = (MapOverlay)this.overlay;
    }

    public ChildMapOverlay(String path, Map<String, V> value, JsonOverlay<?> parent, OverlayFactory<Map<String, V>> factory, ReferenceRegistry refReg) {
        super(path, value, parent, factory, refReg);
    }

    @Override
    protected boolean isPartial() {
        return ((MapOverlay.MapOverlayFactory)this.factory).getKeyPattern() != null;
    }

    @Override
    protected boolean matchesPath(JsonPointer path) {
        if (super.matchesPath(path)) {
            String key = super.tailPath(path).getMatchingProperty();
            Pattern keyPattern = this.mapOverlay.getKeyPattern();
            return keyPattern == null || keyPattern.matcher(key).matches();
        }
        return false;
    }

    public boolean containsKey(String name) {
        return this.mapOverlay.containsKey(name);
    }

    public V _get(String name) {
        return this.mapOverlay.get(name);
    }

    public void _set(String name, V value) {
        this.mapOverlay.set(name, value);
    }

    public void _remove(String name) {
        this.mapOverlay.remove(name);
    }

    public int _size() {
        return this.mapOverlay.size();
    }

    public ChildOverlay<V> _getChild(String key) {
        return (ChildOverlay)this.mapOverlay.getOverlay(key);
    }
}

