/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import java.util.Map;

public class JsonPath {
    private final JsonPointer path;
    private final int pathLen;

    public JsonPath(String path) {
        boolean emptyPath = path == null || path.isEmpty();
        this.path = JsonPointer.compile((String)(emptyPath ? "" : "/" + path));
        this.pathLen = emptyPath ? 0 : path.split("/").length;
    }

    protected boolean matchesPath(JsonPointer testPath) {
        JsonPointer ourPath = this.path;
        while (!ourPath.matches()) {
            if (!testPath.matchesProperty(ourPath.getMatchingProperty())) {
                return false;
            }
            ourPath = ourPath.tail();
            testPath = testPath.tail();
        }
        return true;
    }

    protected JsonPointer tailPath(JsonPointer path) {
        for (int i = 0; i < this.pathLen; ++i) {
            path = path.tail();
        }
        return path;
    }

    public JsonNode setInPath(JsonNode container, JsonNode value) {
        if (this.path.matches()) {
            if (container.isMissingNode()) {
                return value;
            }
            if (this.canMerge(container, value, null)) {
                return this.merge(container, value, null);
            }
            if (this.canAdd(container, value)) {
                return this.add(container, value);
            }
            throw this.badStructure();
        }
        if (container.isObject() || container.isMissingNode()) {
            container = container.isMissingNode() ? JsonOverlay.jsonObject() : container;
            this.setInPath((ObjectNode)container, this.path, value);
            return container;
        }
        throw this.badStructure();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setInPath(ObjectNode obj, JsonPointer path, JsonNode value) {
        String key = path.getMatchingProperty();
        if ((path = path.tail()).matches()) {
            if (!obj.has(key)) {
                obj.set(key, value);
                return;
            } else if (this.canMerge((JsonNode)obj, value, key)) {
                this.merge((JsonNode)obj, value, key);
                return;
            } else {
                if (!this.canAdd((JsonNode)obj, value)) throw this.badStructure();
                this.add((JsonNode)obj, value);
            }
            return;
        } else {
            obj = obj.has(key) ? (ObjectNode)obj.get(key) : obj.putObject(key);
            this.setInPath(obj, path, value);
        }
    }

    private boolean canMerge(JsonNode container, JsonNode value, String key) {
        ObjectNode obj;
        if (!container.isObject() && !container.isMissingNode()) {
            return false;
        }
        ObjectNode objectNode = obj = container.isMissingNode() ? JsonOverlay.jsonObject() : (ObjectNode)container;
        if (key != null && obj.has(key) && !obj.get(key).isObject()) {
            return false;
        }
        return value.isObject() && !value.isMissingNode();
    }

    private JsonNode merge(JsonNode container, JsonNode value, String key) {
        ObjectNode into;
        ObjectNode result = into = container.isMissingNode() ? JsonOverlay.jsonObject() : (ObjectNode)container;
        if (key != null) {
            ObjectNode objectNode = into = into.has(key) ? (ObjectNode)into.get(key) : into.putObject(key);
        }
        if (!value.isMissingNode()) {
            ObjectNode from = (ObjectNode)value;
            for (Map.Entry field : JsonOverlay.iterable(from.fields())) {
                into.set((String)field.getKey(), (JsonNode)field.getValue());
            }
        }
        return result;
    }

    private boolean canAdd(JsonNode container, JsonNode value) {
        return container.isArray();
    }

    private JsonNode add(JsonNode container, JsonNode value) {
        ((ArrayNode)container).add(value);
        return container;
    }

    private IllegalStateException badStructure() {
        return new IllegalStateException("Value is incompatible with existing JSON structure");
    }

    public String toString() {
        return this.path.matches() ? "*" : this.path.toString();
    }
}

