/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.ChildListOverlay;
import com.reprezen.jsonoverlay.ChildMapOverlay;
import com.reprezen.jsonoverlay.ChildOverlay;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class PropertiesOverlay<V>
extends JsonOverlay<V> {
    private List<ChildOverlay<?>> children = Lists.newArrayList();
    private static Map<Class<?>, List<String>> propertyNames = Maps.newHashMap();
    private boolean elaborated = false;
    private boolean deferElaboration = false;

    protected PropertiesOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.deferElaboration = json.isMissingNode();
        this.gatherPropertyNames();
    }

    public PropertiesOverlay(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.elaborated = true;
        this.gatherPropertyNames();
    }

    private void gatherPropertyNames() {
        if (!propertyNames.containsKey(this.getClass())) {
            ArrayList names = Lists.newArrayList();
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!IJsonOverlay.class.isAssignableFrom(field.getType())) continue;
                names.add(field.getName());
            }
            propertyNames.put(this.getClass(), names);
        }
    }

    List<String> getPropertyNames() {
        return propertyNames.get(this.getClass());
    }

    protected void maybeElaborateChildrenAtCreation() {
        if (!this.deferElaboration) {
            this.ensureElaborated();
        }
    }

    protected void ensureElaborated() {
        if (!this.elaborated) {
            this.elaborateChildren();
            this.elaborated = true;
        }
    }

    protected void elaborateChildren() {
    }

    @Override
    public boolean _isElaborated() {
        return this.elaborated;
    }

    @Override
    public AbstractJsonOverlay<?> _findInternal(JsonPointer path) {
        for (ChildOverlay<?> child : this.children) {
            AbstractJsonOverlay<?> found;
            if (!child.matchesPath(path) || (found = child._find(child.tailPath(path))) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public V fromJson(JsonNode json) {
        PropertiesOverlay result = this;
        return (V)result;
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        MissingNode obj = PropertiesOverlay.jsonMissing();
        for (ChildOverlay<?> child : this.children) {
            JsonNode childJson = child._toJson(options.minus(SerializationOptions.Option.KEEP_ONE_EMPTY));
            if (childJson.isMissingNode()) continue;
            obj = child.getPath().setInPath((JsonNode)obj, childJson);
        }
        JsonNode result = this.fixJson((JsonNode)obj);
        return result.size() > 0 || options.isKeepThisEmpty() ? result : PropertiesOverlay.jsonMissing();
    }

    protected JsonNode fixJson(JsonNode json) {
        return json;
    }

    @Override
    V _get() {
        this.ensureElaborated();
        return super._get();
    }

    public V _get(boolean elaborate) {
        return elaborate ? this._get() : super._get();
    }

    AbstractJsonOverlay<?> _get(String fieldName) {
        Optional<Field> field = Stream.of(this.getClass().getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst();
        if (field.isPresent()) {
            try {
                field.get().setAccessible(true);
                return (AbstractJsonOverlay)field.get().get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void _set(V value) {
        super._set(value);
        this.elaborateChildren();
    }

    protected <T> ChildOverlay<T> createChild(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<T> factory) {
        return create ? this.createChild(path, parent, factory) : null;
    }

    protected <T> ChildOverlay<T> createChild(String path, JsonOverlay<?> parent, OverlayFactory<T> factory) {
        ChildOverlay<T> child = new ChildOverlay<T>(path, this.json.at("/" + path), parent, factory, this.refReg);
        if (child.getOverlay() != null) {
            child.getOverlay().setPathInParent(path);
        }
        this.children.add(child);
        return child;
    }

    protected <T> ChildMapOverlay<T> createChildMap(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<T> factory, String keyPattern) {
        return create ? this.createChildMap(path, parent, factory, keyPattern) : null;
    }

    protected <T> ChildMapOverlay<T> createChildMap(String path, JsonOverlay<?> parent, OverlayFactory<T> factory, String keyPattern) {
        ChildMapOverlay child = new ChildMapOverlay(path, this.json.at(this.pathPointer(path)), parent, MapOverlay.getFactory(factory, keyPattern), this.refReg);
        child.getOverlay().setPathInParent(path);
        this.children.add(child);
        return child;
    }

    protected <T> ChildListOverlay<T> createChildList(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<T> factory) {
        return create ? this.createChildList(path, parent, factory) : null;
    }

    protected <T> ChildListOverlay<T> createChildList(String path, JsonOverlay<?> parent, OverlayFactory<T> factory) {
        ChildListOverlay child = new ChildListOverlay(path, this.json.at(this.pathPointer(path)), parent, ListOverlay.getFactory(factory), this.refReg);
        child.getOverlay().setPathInParent(path);
        this.children.add(child);
        return child;
    }

    private JsonPointer pathPointer(String path) {
        return path == null || path.isEmpty() ? JsonPointer.compile((String)"") : JsonPointer.compile((String)("/" + path));
    }

    @Override
    protected void elaborate() {
        this.maybeElaborateChildrenAtCreation();
    }

    boolean isReference(String name) {
        ChildOverlay childOverlay = (ChildOverlay)this._get(name);
        return childOverlay.isReference();
    }

    Reference getReference(String name) {
        ChildOverlay childOverlay = (ChildOverlay)this._get(name);
        return childOverlay.getReference();
    }
}

