/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.reprezen.jsonoverlay.JsonLoader;
import com.reprezen.jsonoverlay.ResolutionBase;
import com.reprezen.jsonoverlay.ResolutionException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ResolutionBaseRegistry {
    private Map<String, ResolutionBase> instances = Maps.newConcurrentMap();
    private final JsonLoader jsonLoader;

    public ResolutionBaseRegistry(JsonLoader jsonLoader) {
        this.jsonLoader = jsonLoader;
    }

    public ResolutionBase of(URL baseUrl, boolean resolve) {
        return this.of(baseUrl, baseUrl.toString(), resolve);
    }

    public Collection<ResolutionBase> getAllBases() {
        HashSet allBases = Sets.newHashSet();
        allBases.addAll(this.instances.values());
        return allBases;
    }

    public ResolutionBase get(String urlString) {
        return this.instances.get(urlString);
    }

    public ResolutionBase of(String rawUrlString, boolean resolve) {
        try {
            URL url = new URL(rawUrlString);
            return this.of(url, rawUrlString, resolve);
        }
        catch (MalformedURLException e) {
            return new ResolutionBase(rawUrlString, new ResolutionException("Invalid URL: " + rawUrlString, e), this);
        }
    }

    public ResolutionBase register(String urlString, JsonNode json) {
        ResolutionBase base = new ResolutionBase(urlString, json, this);
        this.instances.put(urlString, base);
        return base;
    }

    public JsonLoader getJsonLoader() {
        return this.jsonLoader;
    }

    private ResolutionBase of(URL baseUrl, String rawUrlString, boolean resolve) {
        if (this.instances.containsKey(rawUrlString)) {
            return this.instances.get(rawUrlString);
        }
        try {
            ResolutionBase base;
            String urlString = ResolutionBaseRegistry.normalizeUrlString(baseUrl);
            if (this.instances.containsKey(urlString)) {
                base = this.instances.get(urlString);
                this.instances.put(rawUrlString, base);
            } else {
                base = new ResolutionBase(urlString, this);
                this.instances.put(urlString, base);
                this.instances.put(baseUrl.toString(), base);
            }
            if (resolve && !base.isResolved()) {
                base.resolve();
            }
            return base;
        }
        catch (ResolutionException e) {
            if (!this.instances.containsKey(rawUrlString)) {
                this.instances.put(rawUrlString, new ResolutionBase(rawUrlString, e, this));
            }
            return this.instances.get(rawUrlString);
        }
    }

    private static String normalizeUrlString(URL url) {
        String urlString = url.toString();
        if (urlString.contains("#")) {
            urlString = urlString.substring(0, urlString.indexOf(35));
        }
        try {
            URI uri = new URI(urlString).normalize();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new ResolutionException("Invalid document URI", e);
        }
    }
}

