/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;

public abstract class OverlayFactory<V> {
    private final Class<? extends AbstractJsonOverlay<? super V>> overlayClass = this.getOverlayClass();

    public JsonOverlay<V> create(V value, JsonOverlay<?> parent, ReferenceRegistry refReg, Reference ref) {
        JsonOverlay<V> overlay = this._create(value, parent, refReg);
        overlay.setReference(ref);
        return overlay;
    }

    public AbstractJsonOverlay<V> create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg, Reference ref) {
        return this.create(json, parent, false, refReg, ref);
    }

    public AbstractJsonOverlay<V> create(JsonNode json, JsonOverlay<?> parent, boolean partial, ReferenceRegistry refReg, Reference ref) {
        JsonOverlay overlay = (JsonOverlay)this.create(json, parent, partial, refReg);
        overlay.setReference(ref);
        return overlay;
    }

    protected AbstractJsonOverlay<V> create(JsonNode json, JsonOverlay<?> parent, boolean partial, ReferenceRegistry refReg) {
        if (!partial && refReg.hasOverlay(json) && this.isCompatible(refReg.getOverlay(json))) {
            JsonOverlay overlay = (JsonOverlay)refReg.getOverlay(json);
            if (parent != null) {
                overlay.setParent(parent);
            }
            return overlay;
        }
        JsonOverlay<V> overlay = this._create(json, parent, refReg);
        if (!partial) {
            refReg.setOverlay(json, overlay);
        }
        overlay.elaborate();
        return overlay;
    }

    public boolean isCompatible(AbstractJsonOverlay<?> overlay) {
        return this.overlayClass.isAssignableFrom(overlay.getClass());
    }

    protected abstract Class<? extends AbstractJsonOverlay<? super V>> getOverlayClass();

    protected abstract JsonOverlay<V> _create(V var1, JsonOverlay<?> var2, ReferenceRegistry var3);

    protected abstract JsonOverlay<V> _create(JsonNode var1, JsonOverlay<?> var2, ReferenceRegistry var3);
}

