/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.reprezen.jsonoverlay.gen.Template;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TypeData {
    private Collection<Type> types;
    private Map<String, String> imports = Maps.newHashMap();
    private List<String> defaultExtendInterfaces = null;
    private Map<String, Type> typeMap = null;
    private String modelType = null;
    private String discriminator = null;
    @JsonProperty
    private Object decls;

    public void init() {
        this.typeMap = Maps.uniqueIndex(this.types, (Function)new Function<Type, String>(){

            public String apply(Type type) {
                return type.getName();
            }
        });
        for (Type type : this.types) {
            type.init(this);
        }
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public Collection<Type> getTypes() {
        return this.types;
    }

    public Map<String, Type> getTypeMap() {
        return this.typeMap;
    }

    public Type getType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public List<String> getDefaultExtendInterfaces() {
        return this.defaultExtendInterfaces;
    }

    public static enum Structure {
        scalar,
        collection,
        map;

    }

    public static class Method {
        private String name;
        private String type;
        private List<String> argDecls;
        private List<String> code;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public List<String> getArgDecls() {
            return this.argDecls;
        }

        public List<String> getCode() {
            return this.code;
        }
    }

    public static class Field {
        private String name;
        private String plural;
        private Structure structure = Structure.scalar;
        private String type;
        private String keyName = "name";
        private List<String> keyDecls;
        private boolean selfKeyed = false;
        private String keyPattern;
        private boolean noImpl;
        private String id;
        private boolean boolDefault = false;
        private String parentPath;
        private String createTest;
        private Type container;

        public void init(String id, Type container) {
            this.id = id;
            this.container = container;
            if (this.name == null) {
                String[] parts = id.split("/");
                String lastPart = parts[parts.length - 1];
                String defaultName = lastPart.substring(0, 1).toUpperCase() + lastPart.substring(1);
                if (this.structure == Structure.scalar) {
                    this.name = defaultName;
                } else {
                    String string = this.name = defaultName.endsWith("s") ? defaultName.substring(0, defaultName.length() - 1) : defaultName;
                }
            }
            if (this.type == null) {
                this.type = this.getTypeData().getType(this.name) != null ? this.name : "String";
            }
        }

        public String getId() {
            return this.id;
        }

        public Type getContainer() {
            return this.container;
        }

        public TypeData getTypeData() {
            return this.container.getTypeData();
        }

        public String getName() {
            return this.name;
        }

        public String getLcName() {
            String lcName;
            switch (lcName = this.lcFirst(this.name)) {
                case "default": 
                case "enum": {
                    lcName = lcName + "Value";
                }
            }
            return lcName;
        }

        public String getPlural() {
            return this.plural != null ? this.plural : this.name + "s";
        }

        public String getLcPlural() {
            return this.lcFirst(this.getPlural());
        }

        public Structure getStructure() {
            return this.structure;
        }

        public String getType() {
            return this.type.equals("Primitive") ? "Object" : this.type;
        }

        String lcFirst(String s) {
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }

        public String getKeyName() {
            return this.keyName;
        }

        public Collection<String> getKeyDecls() {
            return this.keyDecls;
        }

        public boolean isSelfKeyed() {
            return this.selfKeyed;
        }

        public String getKeyPattern() {
            return this.keyPattern;
        }

        public String getCreateTest() {
            if (this.createTest != null) {
                if (this.createTest.startsWith(".")) {
                    return Template.t("json.at(${qpointer})${0}", this, this.createTest);
                }
                if (this.createTest.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
                    return Template.t("${0}(json.at(${qpointer}))", this, this.createTest);
                }
            }
            return this.createTest;
        }

        public boolean isNoImpl() {
            return this.noImpl;
        }

        public boolean isBoolean() {
            return this.getType().equals("Boolean");
        }

        public boolean getBoolDefault() {
            return this.boolDefault;
        }

        public String getParentPath() {
            return this.parentPath != null ? this.parentPath : this.id;
        }

        public String getImplType() {
            Type objectType = this.getContainer().getTypeData().getTypeMap().get(this.getType());
            return Type.getImplType(objectType != null ? objectType.getName() : this.type);
        }

        public boolean isScalarType() {
            switch (this.getType()) {
                case "String": 
                case "Integer": 
                case "Number": 
                case "Boolean": 
                case "Primitive": 
                case "Object": {
                    return true;
                }
            }
            return false;
        }

        private String getOverlayVariant() {
            switch (this.structure) {
                case scalar: {
                    return "";
                }
                case collection: {
                    return "List";
                }
                case map: {
                    return "Map";
                }
            }
            return null;
        }

        public String getPropertyName() {
            return this.structure == Structure.scalar ? this.getLcName() : this.getLcPlural();
        }

        public String getPropertyType() {
            return Template.t("Child${0}Overlay<${type}>", this, this.getOverlayVariant());
        }

        public String getPropertyNew() {
            String createTest = this.getCreateTest();
            createTest = createTest != null ? createTest + ", " : "";
            switch (this.structure) {
                case scalar: {
                    return Template.t("createChild(${0}${qpath}, this, ${implType}.factory)", this, createTest);
                }
                case collection: {
                    return Template.t("createChildList(${0}${qpath}, this, ${implType}.factory)", this, createTest);
                }
                case map: {
                    return Template.t("createChildMap(${0}${qpath}, this, ${implType}.factory, ${qkeyPat})", this, createTest);
                }
            }
            return null;
        }

        public String getOverlayType() {
            return this.getType() + (this.isScalarType() ? "Overlay" : "");
        }

        public String getTypeInCollection() {
            return this.isScalarType() ? this.type : Template.t("? extends ${type}", this, new String[0]);
        }
    }

    public static class Type {
        private String name;
        private Map<String, Field> fields = Maps.newLinkedHashMap();
        private List<String> extendInterfaces = Lists.newArrayList();
        private List<Method> extraMethods = Lists.newArrayList();
        private Map<String, Collection<String>> imports = Maps.newHashMap();
        private boolean noGen = false;
        private String extensionOf;
        private Map<String, String> renames = Maps.newHashMap();
        @JsonProperty(value="abstract")
        private boolean abstractType = false;
        private String discriminator = null;
        private String discriminatorValue = null;
        private List<String> enumValues = Lists.newArrayList();
        private TypeData typeData;

        public void init(TypeData typeData) {
            this.typeData = typeData;
            for (Map.Entry<String, Field> field : this.fields.entrySet()) {
                field.getValue().init(field.getKey(), this);
            }
        }

        public TypeData getTypeData() {
            return this.typeData;
        }

        public Collection<String> getRequiredImports(String ... moduleTypes) {
            List interfaces;
            LinkedHashSet results = Sets.newLinkedHashSet();
            List list = interfaces = this.extendInterfaces != null ? this.extendInterfaces : this.typeData.defaultExtendInterfaces;
            if (interfaces != null) {
                results.addAll(interfaces);
            }
            for (String moduleType : moduleTypes) {
                if (this.imports.get(moduleType) == null) continue;
                results.addAll(this.imports.get(moduleType));
            }
            return results;
        }

        public String getIntfExtendsDecl() {
            List interfaces = this.extendInterfaces != null ? this.extendInterfaces : this.typeData.defaultExtendInterfaces;
            return interfaces != null ? " extends " + StringUtils.join((Iterable)interfaces, (String)", ") : "";
        }

        public String getName() {
            return this.name;
        }

        public String getLcName() {
            String lcName = this.lcFirst(this.name);
            return lcName;
        }

        public Map<String, Field> getFields() {
            return this.fields;
        }

        public List<String> getExtendInterfaces() {
            return this.extendInterfaces;
        }

        public List<Method> getExtraMethods() {
            return this.extraMethods;
        }

        public Map<String, Collection<String>> getImports() {
            return this.imports;
        }

        public boolean isNoGen() {
            return this.noGen;
        }

        public String getExtensionOf() {
            return this.extensionOf;
        }

        public Map<String, String> getRenames() {
            return this.renames;
        }

        public boolean isAbstract() {
            return this.abstractType;
        }

        public String getDiscriminator() {
            return this.discriminator != null ? this.discriminator : this.typeData.getDiscriminator();
        }

        public String getDiscriminatorValue() {
            return this.discriminatorValue != null ? this.discriminatorValue : this.name;
        }

        public List<String> getEnumValues() {
            return this.enumValues;
        }

        public String getImplType() {
            return this.isNoGen() ? this.name : Type.getImplType(this.name);
        }

        public static String getImplType(String typeName) {
            switch (typeName) {
                case "String": 
                case "Integer": 
                case "Number": 
                case "Boolean": 
                case "Primitive": 
                case "Object": {
                    return typeName + "Overlay";
                }
            }
            return typeName + "Impl";
        }

        String lcFirst(String s) {
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }
    }
}

