/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.apidescription;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.wfs30.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LandingPage
extends CommonFixture {
    private JsonPath response;

    @Test(description="Implements A.4.2.1. Landing Page Retrieval (Requirement 1)", groups={"landingpage"})
    public void landingPageRetrieval() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
    }

    @Test(description="Implements A.4.2.2. Landing Page Validation (Requirement 2)", groups={"landingpage"}, dependsOnMethods={"landingPageRetrieval"})
    public void landingPageValidation() {
        List links = this.response.getList("links");
        Set<String> linkTypes = this.collectLinkTypes(links);
        boolean expectedLinkTypesExists = linkTypes.contains("service") && linkTypes.contains("conformance") && linkTypes.contains("data");
        Assert.assertTrue((boolean)expectedLinkTypesExists, (String)("The landing page must include at least links with relation type 'service', 'conformance' and 'data', but contains " + linkTypes));
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

