/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.collections;

import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opengis.cite.wfs30.CommonFixture;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.WFS3;
import org.opengis.cite.wfs30.openapi3.OpenApiUtils;
import org.opengis.cite.wfs30.openapi3.TestPoint;
import org.opengis.cite.wfs30.util.BBox;
import org.opengis.cite.wfs30.util.JsonUtils;
import org.opengis.cite.wfs30.util.TemporalExtent;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GetFeaturesOperation
extends CommonFixture {
    private final Map<String, ResponseData> collectionNameAndResponse = new HashMap<String, ResponseData>();
    private List<Map<String, Object>> collections;
    private OpenApi3 apiModel;

    @DataProvider(name="collectionItemUris")
    public Iterator<Object[]> collectionItemUris(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            collectionsData.add(new Object[]{collection});
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionItemUrisWithLimit")
    public Iterator<Object[]> collectionItemUrisWithLimits(ITestContext testContext) {
        ArrayList<Object[]> collectionsWithLimits = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            Parameter limit = this.findParameterByName((String)collection.get("name"), "limit");
            int[] ints = this.getTwoRandomLimits(limit);
            collectionsWithLimits.add(new Object[]{collection, ints[0]});
            collectionsWithLimits.add(new Object[]{collection, ints[0]});
        }
        return collectionsWithLimits.iterator();
    }

    @DataProvider(name="collectionItemUrisWithBboxes")
    public Iterator<Object[]> collectionItemUrisWithBboxes(ITestContext testContext) {
        ArrayList<Object[]> collectionsWithBboxes = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            BBox extent = JsonUtils.parseSpatialExtent(collection);
            if (extent == null) continue;
            collectionsWithBboxes.add(new Object[]{collection, extent});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-1.5, 50.0, 1.5, 53.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-80.0, -5.0, -70.0, 5.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(177.0, 65.0, -177.0, 70.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(-70.0, -20.0, -70.0, 160.0)});
            collectionsWithBboxes.add(new Object[]{collection, new BBox(70.0, -20.0, 70.0, 160.0)});
        }
        return collectionsWithBboxes.iterator();
    }

    @DataProvider(name="collectionItemUrisWithTimes")
    public Iterator<Object[]> collectionItemUrisWithTimes(ITestContext testContext) {
        ArrayList<Object[]> collectionsWithTimes = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            TemporalExtent temporalExtent = JsonUtils.parseTemporalExtent(collection);
            if (temporalExtent == null) continue;
            ZonedDateTime begin = temporalExtent.getBegin();
            ZonedDateTime end = temporalExtent.getEnd();
            Duration between = Duration.between(begin, end);
            Duration quarter = between.dividedBy(4L);
            ZonedDateTime beginInterval = begin.plus(quarter);
            ZonedDateTime endInterval = beginInterval.plus(quarter);
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDate(begin), beginInterval, null});
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDateRange(beginInterval, endInterval), beginInterval, endInterval});
            LocalDate beginIntervalDate = beginInterval.toLocalDate();
            LocalDate endIntervalDate = beginIntervalDate.plusDays(2L);
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDateRangeWithDuration(beginIntervalDate, endIntervalDate), beginIntervalDate, endIntervalDate});
        }
        return collectionsWithTimes.iterator();
    }

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        this.collections = (List)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS.getName());
    }

    @Test(description="Implements A.4.4.9. Validate the Get Features Operation (Requirement 17, 24)", groups={"getFeaturesBase"}, dataProvider="collectionItemUris", dependsOnGroups={"collections"})
    public void validateTheGetFeaturesOperation(ITestContext testContext, Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        String getFeaturesUrl = this.findGetFeaturesUrlForGeoJson(collection);
        if (getFeaturesUrl == null) {
            throw new SkipException("Could not find url for collection with name " + collectionName + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        ResponseData responseData = new ResponseData(response, timeStampBeforeResponse, timeStampAfterResponse);
        this.collectionNameAndResponse.put(collectionName, responseData);
        this.addFeatureIdToTestContext(testContext, collectionName, response);
    }

    @Test(description="Implements A.4.4.10. Validate the Get Features Operation Response (Requirement 25, 26)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void validateTheGetFeaturesOperationResponse_Links(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        ResponseData response = this.collectionNameAndResponse.get(collectionName);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with name " + collectionName);
        }
        List<TestPoint> testPointsForNamedCollection = OpenApiUtils.retrieveTestPoints(this.apiModel, WFS3.PATH.COLLECTIONS, collectionName + "/items");
        if (testPointsForNamedCollection.isEmpty()) {
            throw new SkipException("Could not find collection with name " + collectionName + " in the OpenAPI document");
        }
        TestPoint testPoint = testPointsForNamedCollection.get(0);
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, (String)"Feature Collection Metadata document must include a link for itself");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupport(testPoint, linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        Assert.assertTrue((boolean)typesWithoutLink.isEmpty(), (String)("Feature Collection Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink));
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(links);
        Assert.assertTrue((boolean)linksWithoutRelOrType.isEmpty(), (String)("Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType));
    }

    @Test(description="Implements A.4.4.10. Validate the Get Features Operation Response (Requirement 27)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void validateTheGetFeaturesOperationResponse_property_timeStamp(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        ResponseData response = this.collectionNameAndResponse.get(collectionName);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with name " + collectionName);
        }
        JsonPath jsonPath = response.jsonPath();
        this.assertTimeStamp(collectionName, jsonPath, response.timeStampBeforeResponse, response.timeStampAfterResponse, true);
    }

    @Test(description="Implements A.4.4.10. Validate the Get Features Operation Response (Requirement 29)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void validateGetFeaturesOperationResponse_property_numberReturned(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        ResponseData response = this.collectionNameAndResponse.get(collectionName);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with name " + collectionName);
        }
        JsonPath jsonPath = response.jsonPath();
        this.assertNumberReturned(collectionName, jsonPath, true);
    }

    @Test(description="Implements A.4.4.10. Validate the Get Features Operation Response (Requirement 28)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void validateTheGetFeaturesOperationResponse_property_numberMatched(Map<String, Object> collection) throws URISyntaxException {
        String collectionName = (String)collection.get("name");
        ResponseData response = this.collectionNameAndResponse.get(collectionName);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with name " + collectionName);
        }
        JsonPath jsonPath = response.jsonPath();
        this.assertNumberMatched(collectionName, jsonPath, true);
    }

    @Test(description="Implements A.4.4.11. Limit Parameter (Requirement 18)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void limitParameter(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        Parameter limit = this.findParameterByName(collectionName, "limit");
        Assert.assertNotNull((Object)limit, (String)("Required limit parameter for collections item with name '" + collectionName + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' but was '%s'";
        Assert.assertEquals((String)limit.getName(), (String)"limit", (String)String.format(msg, "name", "limit", limit.getName()));
        Assert.assertEquals((String)limit.getIn(), (String)"query", (String)String.format(msg, "in", "query", limit.getIn()));
        Assert.assertFalse((boolean)limit.getRequired(), (String)String.format(msg, "required", "false", limit.getRequired()));
        Assert.assertEquals((String)limit.getStyle(), (String)"form", (String)String.format(msg, "style", "form", limit.getStyle()));
        Assert.assertFalse((boolean)limit.getExplode(), (String)String.format(msg, "explode", "false", limit.getExplode()));
        Schema schema = limit.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"integer", (String)String.format(msg, "schema -> type", "integer", schema.getType()));
        Assert.assertEquals((Object)schema.getMinimum(), (Object)1, (String)String.format(msg, "schema -> minimum", "1", schema.getMinimum()));
        this.assertIntegerGreaterZero(schema.getMinimum(), "schema -> minimum");
        this.assertIntegerGreaterZero(schema.getDefault(), "schema -> default");
    }

    @Test(description="Implements A.4.4.11. Limit Parameter (Requirement 19)", dataProvider="collectionItemUrisWithLimit", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void limitParameter_requests(Map<String, Object> collection, int limit) throws URISyntaxException {
        String collectionName = (String)collection.get("name");
        String getFeaturesUrl = this.findGetFeaturesUrlForGeoJson(collection);
        if (getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with name " + collectionName + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("limit", new Object[]{limit}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        JsonPath jsonPath = response.jsonPath();
        int numberOfFeatures = jsonPath.getList("features").size();
        Assert.assertTrue((numberOfFeatures <= limit ? 1 : 0) != 0, (String)("Number of features for collection with name " + collectionName + " is unexpected (was " + numberOfFeatures + "), expected are " + limit + " or less"));
        this.assertTimeStamp(collectionName, jsonPath, timeStampBeforeResponse, timeStampAfterResponse, false);
        this.assertNumberReturned(collectionName, jsonPath, false);
        this.assertNumberMatched(collectionName, jsonPath, false);
    }

    @Test(description="Implements A.4.4.12. Bounding Box Parameter (Requirement 20)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void boundingBoxParameter(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        Parameter bbox = this.findParameterByName(collectionName, "bbox");
        Assert.assertNotNull((Object)bbox, (String)("Required bbox parameter for collections item with name '" + collectionName + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' for collections item with name '" + collectionName + "' but was '%s'.";
        Assert.assertEquals((String)bbox.getName(), (String)"bbox", (String)String.format(msg, "name", "bbox", bbox.getName()));
        Assert.assertEquals((String)bbox.getIn(), (String)"query", (String)String.format(msg, "in", "query", bbox.getIn()));
        Assert.assertFalse((boolean)bbox.getRequired(), (String)String.format(msg, "required", "false", bbox.getRequired()));
        Assert.assertEquals((String)bbox.getStyle(), (String)"form", (String)String.format(msg, "style", "form", bbox.getStyle()));
        Assert.assertFalse((boolean)bbox.getExplode(), (String)String.format(msg, "explode", "false", bbox.getExplode()));
        Schema schema = bbox.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"array", (String)String.format(msg, "schema -> type", "array", schema.getType()));
        Assert.assertEquals((int)schema.getMinItems(), (int)4, (String)String.format(msg, "schema -> minItems", "4", schema.getMinItems()));
        Assert.assertEquals((int)schema.getMaxItems(), (int)6, (String)String.format(msg, "schema -> maxItems", "6", schema.getMaxItems()));
        String itemsType = schema.getItemsSchema().getType();
        Assert.assertEquals((String)itemsType, (String)"number", (String)String.format(msg, "schema -> items -> type", "number", itemsType));
    }

    @Test(description="Implements A.4.4.12. Bounding Box Parameter (Requirement 21)", dataProvider="collectionItemUrisWithBboxes", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void boundingBoxParameter_requests(Map<String, Object> collection, BBox bbox) throws URISyntaxException {
        String collectionName = (String)collection.get("name");
        String getFeaturesUrl = this.findGetFeaturesUrlForGeoJson(collection);
        if (getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with name " + collectionName + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("bbox", new Object[]{bbox.asQueryParameter()}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        JsonPath jsonPath = response.jsonPath();
        this.assertTimeStamp(collectionName, jsonPath, timeStampBeforeResponse, timeStampAfterResponse, false);
        this.assertNumberReturned(collectionName, jsonPath, false);
        this.assertNumberMatched(collectionName, jsonPath, false);
    }

    @Test(description="Implements A.4.4.13. Time Parameter (Requirement 22)", dataProvider="collectionItemUris", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void timeParameter(Map<String, Object> collection) {
        String collectionName = (String)collection.get("name");
        Parameter time = this.findParameterByName(collectionName, "time");
        Assert.assertNotNull((Object)time, (String)("Required time parameter for collections item with name '" + collectionName + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' but was '%s'";
        Assert.assertEquals((String)time.getName(), (String)"time", (String)String.format(msg, "name", "time", time.getName()));
        Assert.assertEquals((String)time.getIn(), (String)"query", (String)String.format(msg, "in", "query", time.getIn()));
        Assert.assertFalse((boolean)time.getRequired(), (String)String.format(msg, "required", "false", time.getRequired()));
        Assert.assertEquals((String)time.getStyle(), (String)"form", (String)String.format(msg, "style", "form", time.getStyle()));
        Assert.assertFalse((boolean)time.getExplode(), (String)String.format(msg, "explode", "false", time.getExplode()));
        Schema schema = time.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"string", (String)String.format(msg, "schema -> type", "string", schema.getType()));
    }

    @Test(description="Implements A.4.4.13. Time Parameter (Requirement 23)", dataProvider="collectionItemUrisWithTimes", dependsOnMethods={"validateTheGetFeaturesOperation"})
    public void timeParameter_requests(Map<String, Object> collection, String queryParameter, Object begin, Object end) throws URISyntaxException {
        String collectionName = (String)collection.get("name");
        String getFeaturesUrl = this.findGetFeaturesUrlForGeoJson(collection);
        if (getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with name " + collectionName + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("time", new Object[]{queryParameter}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        JsonPath jsonPath = response.jsonPath();
        this.assertTimeStamp(collectionName, jsonPath, timeStampBeforeResponse, timeStampAfterResponse, false);
        this.assertNumberReturned(collectionName, jsonPath, false);
        this.assertNumberMatched(collectionName, jsonPath, false);
    }

    private void addFeatureIdToTestContext(ITestContext testContext, String collectionName, Response response) {
        String featureId;
        if (response == null) {
            return;
        }
        HashMap<String, String> collectionNameAndFeatureId = (HashMap<String, String>)testContext.getSuite().getAttribute(SuiteAttribute.FEATUREIDS.getName());
        if (collectionNameAndFeatureId == null) {
            collectionNameAndFeatureId = new HashMap<String, String>();
            testContext.getSuite().setAttribute(SuiteAttribute.FEATUREIDS.getName(), collectionNameAndFeatureId);
        }
        if ((featureId = JsonUtils.parseFeatureId(response.jsonPath())) != null) {
            collectionNameAndFeatureId.put(collectionName, featureId);
        }
    }

    private void assertTimeStamp(String collectionName, JsonPath jsonPath, ZonedDateTime timeStampBeforeResponse, ZonedDateTime timeStampAfterResponse, boolean skipIfNoTimeStamp) {
        String timeStamp = jsonPath.getString("timeStamp");
        if (timeStamp == null) {
            if (skipIfNoTimeStamp) {
                throw new SkipException("Property timeStamp is not set in collection items '" + collectionName + "'");
            }
            return;
        }
        ZonedDateTime date = JsonUtils.parseAsDate(timeStamp);
        Assert.assertTrue((boolean)date.isBefore(timeStampAfterResponse), (String)("timeStamp in response must be before the request was send (" + JsonUtils.formatDate(timeStampAfterResponse) + ") but was '" + timeStamp + "'"));
        Assert.assertTrue((boolean)date.isAfter(timeStampBeforeResponse), (String)("timeStamp in response must be after the request was send (" + JsonUtils.formatDate(timeStampBeforeResponse) + ") but was '" + timeStamp + "'"));
    }

    private void assertNumberReturned(String collectionName, JsonPath jsonPath, boolean skipIfNoNumberReturned) {
        if (!JsonUtils.hasProperty("numberReturned", jsonPath)) {
            if (skipIfNoNumberReturned) {
                throw new SkipException("Property numberReturned is not set in collection items '" + collectionName + "'");
            }
            return;
        }
        int numberReturned = jsonPath.getInt("numberReturned");
        int numberOfFeatures = jsonPath.getList("features").size();
        Assert.assertEquals((int)numberReturned, (int)numberOfFeatures, (String)("Value of numberReturned (" + numberReturned + ") does not match the number of features in the response (" + numberOfFeatures + ")"));
    }

    private void assertNumberMatched(String collectionName, JsonPath jsonPath, boolean skipIfNoNumberMatched) throws URISyntaxException {
        if (!JsonUtils.hasProperty("numberMatched", jsonPath)) {
            if (skipIfNoNumberMatched) {
                throw new SkipException("Property numberMatched is not set in collection items '" + collectionName + "'");
            }
            return;
        }
        int numberMatched = jsonPath.getInt("numberMatched");
        int numberOfAllReturnedFeatures = JsonUtils.collectNumberOfAllReturnedFeatures(jsonPath);
        Assert.assertEquals((int)numberMatched, (int)numberOfAllReturnedFeatures, (String)("Value of numberReturned (" + numberMatched + ") does not match the number of features in all responses (" + numberOfAllReturnedFeatures + ")"));
    }

    private Parameter findParameterByName(String collectionName, String name) {
        String collectionItemPath = "/" + WFS3.PATH.COLLECTIONS.getPathItem() + "/" + collectionName + "/items";
        Path path = this.apiModel.getPath(collectionItemPath);
        if (path != null) {
            for (Parameter parameter : path.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
            Operation get = path.getOperation("get");
            for (Parameter parameter : get.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    private String findGetFeaturesUrlForGeoJson(Map<String, Object> collection) {
        List links = (List)collection.get("links");
        for (Object linkObject : links) {
            Map link = (Map)linkObject;
            Object rel = link.get("rel");
            Object type = link.get("type");
            if (!"item".equals(rel) || !"application/geo+json".equals(type)) continue;
            return (String)link.get("href");
        }
        return null;
    }

    private List<String> createListOfMediaTypesToSupport(TestPoint testPoint, Map<String, Object> linkToSelf) {
        Map<String, MediaType> contentMediaTypes = testPoint.getContentMediaTypes();
        ArrayList<String> mediaTypesToSupport = new ArrayList<String>();
        mediaTypesToSupport.addAll(contentMediaTypes.keySet());
        if (linkToSelf != null) {
            mediaTypesToSupport.remove(linkToSelf.get("type"));
        }
        return mediaTypesToSupport;
    }

    private void assertIntegerGreaterZero(Object value, String propertyName) {
        if (value instanceof Number) {
            this.assertIntegerGreaterZero(((Number)value).intValue(), propertyName);
        } else if (value instanceof String) {
            try {
                int valueAsInt = Integer.parseInt((String)value);
                this.assertIntegerGreaterZero(valueAsInt, propertyName);
            }
            catch (NumberFormatException e) {
                String msg = "Expected property '%s' to be an integer, but was '%s'";
                throw new AssertionError((Object)String.format(msg, propertyName, value));
            }
        }
    }

    private void assertIntegerGreaterZero(int value, String propertyName) {
        String msg = "Expected property '%s' to be an integer greater than 0, but was '%s'";
        Assert.assertTrue((value > 0 ? 1 : 0) != 0, (String)String.format(msg, propertyName, value));
    }

    private int[] getTwoRandomLimits(Parameter limit) {
        Schema schema = limit.getSchema();
        int min = schema.getMinimum().intValue();
        int max = schema.getMaximum().intValue();
        if (max > 25) {
            max = 25;
        }
        Random random = new Random();
        return random.ints(2L, min, max).toArray();
    }

    private class ResponseData {
        private final Response response;
        private final ZonedDateTime timeStampBeforeResponse;
        private final ZonedDateTime timeStampAfterResponse;

        public ResponseData(Response response, ZonedDateTime timeStampBeforeResponse, ZonedDateTime timeStampAfterResponse) {
            this.response = response;
            this.timeStampBeforeResponse = timeStampBeforeResponse;
            this.timeStampAfterResponse = timeStampAfterResponse;
        }

        public JsonPath jsonPath() {
            return this.response.jsonPath();
        }
    }
}

