/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.conformance;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.List;
import org.opengis.cite.wfs30.CommonFixture;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.WFS3;
import org.opengis.cite.wfs30.openapi3.OpenApiUtils;
import org.opengis.cite.wfs30.openapi3.TestPoint;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConformanceOperation
extends CommonFixture {
    @DataProvider(name="conformanceUris")
    public Object[][] conformanceUris(ITestContext testContext) {
        OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPoints(apiModel, WFS3.PATH.CONFORMANCE);
        return new Object[][]{testPoints.toArray()};
    }

    @Test(description="Implements A.4.4.2. Validate Conformance Operation (Requirement 5) and A.4.4.3. Validate Conformance Operation Response (Requirement 6)", dataProvider="conformanceUris", dependsOnGroups={"apidefinition"})
    public void validateConformanceOperationAndResponse(TestPoint testPoint) {
        Response response = this.validateConformanceOperation(testPoint);
        this.validateConformanceOperationResponse(testPoint, response);
    }

    private Response validateConformanceOperation(TestPoint testPoint) {
        String testPointUri = testPoint.createUri();
        return (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
    }

    private void validateConformanceOperationResponse(TestPoint testPoint, Response response) {
        ((ValidatableResponse)response.then()).statusCode(200);
        JsonPath jsonPath = response.jsonPath();
        List<String> requirementClasses = this.parseAndValidateRequirementClasses(jsonPath);
        testPoint.addRequirementClasses(requirementClasses);
    }

    List<String> parseAndValidateRequirementClasses(JsonPath jsonPath) {
        ArrayList<String> requirementClasses = new ArrayList<String>();
        List conformsTo = jsonPath.getList("conformsTo");
        Assert.assertNotNull((Object)conformsTo, (String)"Missing member 'conformsTo'.");
        for (Object conformTo : conformsTo) {
            if (conformTo instanceof String) {
                requirementClasses.add((String)conformTo);
                continue;
            }
            throw new AssertionError((Object)("At least one element array 'conformsTo' is not a string value (" + conformTo + ")"));
        }
        return requirementClasses;
    }
}

