/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.openapi3;

import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TestPoint {
    private UriTemplate uriTemplate;
    private Map<String, String> templateReplacement;
    private List<String> requirementClasses;
    private Map<String, MediaType> contentMediaTypes;

    public TestPoint(UriTemplate uriTemplate, Map<String, MediaType> contentMediaTypes) {
        this(uriTemplate, null, contentMediaTypes);
    }

    public TestPoint(UriTemplate uriTemplate, Map<String, String> templateReplacement, Map<String, MediaType> contentMediaTypes) {
        this.uriTemplate = uriTemplate;
        this.templateReplacement = templateReplacement;
        this.contentMediaTypes = contentMediaTypes;
    }

    public UriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public Map<String, String> getTemplateReplacement() {
        return this.templateReplacement;
    }

    public void addTemplateReplacement(String key, String value) {
        if (this.templateReplacement == null) {
            this.templateReplacement = new HashMap<String, String>();
        }
        this.templateReplacement.put(key, value);
    }

    public List<String> getRequirementClasses() {
        return this.requirementClasses;
    }

    public void addRequirementClasses(List<String> requirementClasses) {
        this.requirementClasses = requirementClasses;
    }

    public Map<String, MediaType> getContentMediaTypes() {
        return this.contentMediaTypes;
    }

    public String createUri() {
        if (this.templateReplacement != null) {
            return this.uriTemplate.createURI(this.templateReplacement);
        }
        return this.uriTemplate.createURI(new String[0]);
    }

    public String toString() {
        return "Pattern: " + this.uriTemplate.getPattern() + ", Replacements: " + this.templateReplacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestPoint testPoint = (TestPoint)o;
        return Objects.equals(this.uriTemplate, testPoint.uriTemplate) && Objects.equals(this.templateReplacement, testPoint.templateReplacement) && Objects.equals(this.requirementClasses, testPoint.requirementClasses) && Objects.equals(this.contentMediaTypes, testPoint.contentMediaTypes);
    }

    public int hashCode() {
        return Objects.hash(this.uriTemplate, this.templateReplacement, this.requirementClasses, this.contentMediaTypes);
    }
}

