/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ResolutionBase;
import com.reprezen.jsonoverlay.ResolutionBaseRegistry;
import com.reprezen.jsonoverlay.ResolutionException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Set;
import java.util.UUID;

public class Reference {
    private String refString;
    private String canonRefString;
    private ResolutionBase base;
    private String fragment;
    private Boolean isValid = null;
    private JsonNode json = null;
    private ResolutionException error;
    private String key;
    private final ResolutionBaseRegistry resolutionBaseRegistry;
    private ReferenceRegistry refReg;

    Reference(String refString, String canonicalRefString, ResolutionBase base, ReferenceRegistry refReg) {
        this.refString = refString;
        this.canonRefString = canonicalRefString;
        this.resolutionBaseRegistry = base.getResolutionBaseRegistry();
        this.refReg = refReg;
        int pos = refString.indexOf(35);
        String relUrl = pos < 0 ? refString : refString.substring(0, pos);
        this.base = relUrl.isEmpty() ? base : this.resolutionBaseRegistry.of(base.comprehend(relUrl), false);
        if (pos >= 0) {
            this.fragment = refString.substring(pos);
        }
        if (this.fragment != null) {
            try {
                this.fragment = URLDecoder.decode(this.fragment, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.key = this.canonRefString;
    }

    Reference(String refString, ResolutionBase base, ResolutionException e, ReferenceRegistry refReg) {
        this.refString = refString;
        this.canonRefString = null;
        this.resolutionBaseRegistry = base.getResolutionBaseRegistry();
        this.refReg = refReg;
        this.fragment = null;
        this.base = base;
        this.isValid = false;
        this.error = e;
        this.key = UUID.randomUUID().toString();
    }

    public String getRefString() {
        return this.refString;
    }

    public String getCanonicalRefString() {
        return this.canonRefString;
    }

    public ResolutionBase getBase() {
        return this.base;
    }

    public String getFragment() {
        return this.fragment;
    }

    public JsonNode getJson() {
        if (this.isValid()) {
            return this.json;
        }
        return MissingNode.getInstance();
    }

    public boolean isValid() {
        return this.isValid != null && this.isValid != false;
    }

    public boolean isInvalid() {
        return this.isValid != null && this.isValid == false;
    }

    public boolean isResolved() {
        return this.isValid != null;
    }

    public ResolutionException getError() {
        return this.error;
    }

    public String getErrorReason() {
        return this.error != null ? this.error.getLocalizedMessage() : null;
    }

    public String getKey() {
        return this.key;
    }

    public JsonNode resolve() {
        return this.resolve(true);
    }

    public JsonNode resolve(boolean follow) {
        return this.resolveInternal(follow, Sets.newHashSet());
    }

    private JsonNode resolveInternal(boolean follow, Set<Reference> seen) {
        if (seen.contains(this)) {
            this.resolutionCycle(this);
        } else if (!this.isResolved()) {
            block13: {
                seen.add(this);
                try {
                    JsonNode root = this.base.resolve();
                    if (this.fragment == null) {
                        this.json = root;
                        break block13;
                    }
                    try {
                        this.json = root.at(this.fragment.substring(1));
                        if (this.json.isMissingNode()) {
                            throw new ResolutionException("JSON pointer does not address a value in the containing structure");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new ResolutionException("Failed to resolve JSON pointer", e);
                    }
                }
                catch (ResolutionException e) {
                    this.badResolution("Unresolvable reference", e);
                }
            }
            while (follow && Reference.isReferenceNode(this.json)) {
                Reference ref = this.refReg.getRef(this.json);
                this.json = ref.resolveInternal(follow, seen);
                if (ref.isValid()) continue;
                if (this.inCycle(ref.getError(), seen)) {
                    this.resolutionCycle(ref.getError());
                } else {
                    this.badResolution("Invalid indirect reference", ref.getError());
                }
                return this.json;
            }
            if (!Reference.isReferenceNode(this.json) && this.isValid == null) {
                this.isValid = true;
            }
            seen.remove(this);
        }
        return this.json;
    }

    private void badResolution(String message, ResolutionException e) {
        this.isValid = false;
        this.error = new ResolutionException(message, e);
        this.json = MissingNode.getInstance();
    }

    private boolean inCycle(ResolutionException e, Set<Reference> seen) {
        if (e instanceof ResolutionException.ReferenceCycleException) {
            Reference cycleAnchor = ((ResolutionException.ReferenceCycleException)e).getDetectedAt();
            return seen.contains(cycleAnchor);
        }
        return false;
    }

    private void resolutionCycle(ResolutionException e) {
        this.resolutionCycle(((ResolutionException.ReferenceCycleException)e).getDetectedAt());
    }

    private void resolutionCycle(Reference cycleAnchor) {
        this.isValid = false;
        this.error = new ResolutionException.ReferenceCycleException(cycleAnchor);
        this.json = MissingNode.getInstance();
    }

    public static boolean isReferenceNode(JsonNode node) {
        return node.isObject() && node.has("$ref");
    }

    public String toString() {
        return String.format("Reference[$ref=%s; canonical=%s; valid=%s, badReason=%s]", this.getRefString(), this.getCanonicalRefString(), this.isValid(), this.getErrorReason());
    }
}

