/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ResolutionBase;
import com.reprezen.jsonoverlay.ResolutionBaseRegistry;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Resolver {
    private Set<ResolutionBase> resolvedBases = Sets.newHashSet();
    private final ReferenceRegistry referenceRegistry;
    private final ResolutionBaseRegistry resolutionBaseRegistry;
    private final Predicate<JsonNode> refNodeFilter = new Predicate<JsonNode>(){

        @Override
        public boolean apply(JsonNode node) {
            return node.isObject() && node.has("$ref");
        }
    };

    public Resolver(ReferenceRegistry referenceRegistry, ResolutionBaseRegistry resolutionBaseRegistry) {
        this.referenceRegistry = referenceRegistry;
        this.resolutionBaseRegistry = resolutionBaseRegistry;
    }

    public void preresolve(String ... baseUrls) {
        for (String url : baseUrls) {
            this.preresolve(this.resolutionBaseRegistry.of(url, true));
        }
    }

    public void preresolve(URL ... baseUrls) {
        for (URL url : baseUrls) {
            this.preresolve(this.resolutionBaseRegistry.of(url, true));
        }
    }

    public void preresolve(ResolutionBase base) {
        ArrayDeque<ResolutionBase> toResolve = Queues.newArrayDeque();
        toResolve.add(base);
        while (!toResolve.isEmpty()) {
            toResolve.addAll(this.preresolveBase((ResolutionBase)toResolve.remove()));
        }
    }

    private Collection<ResolutionBase> preresolveBase(ResolutionBase base) {
        ArrayList<ResolutionBase> discoveredBases = Lists.newArrayList();
        if (!this.resolvedBases.contains(base)) {
            this.resolvedBases.add(base);
            if (base.isValid()) {
                for (JsonNode refNode : this.findReferenceNodes(base.getJson())) {
                    JsonNode refString = refNode.get("$ref");
                    String key = this.referenceRegistry.registerRef(refString, base, true);
                    ((ObjectNode)refNode).put("key", key);
                    Reference ref = this.referenceRegistry.getRef(key);
                    if (!ref.isValid() || this.resolvedBases.contains(ref.getBase())) continue;
                    discoveredBases.add(ref.getBase());
                }
            }
        }
        return discoveredBases;
    }

    private Iterable<JsonNode> findReferenceNodes(JsonNode tree) {
        return Iterables.filter(this.treeWalk(tree), this.refNodeFilter);
    }

    private Iterable<JsonNode> treeWalk(JsonNode tree) {
        final ArrayDeque<JsonNode> toVisit = Queues.newArrayDeque();
        toVisit.add(tree);
        return new Iterable<JsonNode>(){

            @Override
            public Iterator<JsonNode> iterator() {
                return new Iterator<JsonNode>(){

                    @Override
                    public boolean hasNext() {
                        return !toVisit.isEmpty();
                    }

                    @Override
                    public JsonNode next() {
                        if (this.hasNext()) {
                            JsonNode next = (JsonNode)toVisit.remove();
                            this.queueChildren(next);
                            return next;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void queueChildren(JsonNode node) {
                        block3: {
                            block2: {
                                if (!node.isArray()) break block2;
                                Iterator<JsonNode> iter = node.elements();
                                while (iter.hasNext()) {
                                    toVisit.addFirst(iter.next());
                                }
                                break block3;
                            }
                            if (!node.isObject()) break block3;
                            Iterator<Map.Entry<String, JsonNode>> iter = node.fields();
                            while (iter.hasNext()) {
                                toVisit.addFirst(iter.next().getValue());
                            }
                        }
                    }
                };
            }
        };
    }
}

