/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public class StringOverlay
extends ScalarOverlay<String> {
    public static OverlayFactory<String> factory = new OverlayFactory<String>(){

        @Override
        protected Class<StringOverlay> getOverlayClass() {
            return StringOverlay.class;
        }

        public StringOverlay _create(String value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new StringOverlay(value, parent, refReg);
        }

        public StringOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new StringOverlay(json, parent, refReg);
        }
    };

    private StringOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    private StringOverlay(String value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    @Override
    public String fromJson(JsonNode json) {
        return json.isTextual() ? json.textValue() : null;
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? StringOverlay.jsonScalar((String)this.value) : StringOverlay.jsonMissing();
    }
}

