/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.ResolvedTypeParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class DelegateProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    @Override
    public void doTransform(List<? extends MutableMemberDeclaration> elements, @Extension TransformationContext context) {
        final Util util = new Util(context);
        Consumer<MutableMemberDeclaration> _function = new Consumer<MutableMemberDeclaration>(){

            @Override
            public void accept(final MutableMemberDeclaration it) {
                boolean _isValidDelegate = util.isValidDelegate(it);
                if (_isValidDelegate) {
                    Consumer<ResolvedMethod> _function = new Consumer<ResolvedMethod>(){

                        @Override
                        public void accept(ResolvedMethod method) {
                            util.implementMethod(it, method);
                        }
                    };
                    util.getMethodsToImplement(it).forEach(_function);
                }
            }
        };
        elements.forEach(_function);
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        protected boolean _isValidDelegate(FieldDeclaration it) {
            return this.hasValidType(it) && !this.hasDelegationConflicts(it) && this.areListedInterfacesValid(it);
        }

        protected boolean _isValidDelegate(MethodDeclaration it) {
            return this.hasValidType(it) && this.hasValidSignature(it) && !this.hasDelegationConflicts(it) && this.areListedInterfacesValid(it);
        }

        public boolean hasValidType(MemberDeclaration it) {
            boolean _xifexpression = false;
            if (this.getType(it) == null || this.getType(it).isInferred()) {
                boolean _xblockexpression = false;
                this.context.addError(it, "Cannot use inferred types on delegates");
                _xifexpression = _xblockexpression = false;
            } else {
                _xifexpression = true;
            }
            return _xifexpression;
        }

        protected TypeReference _getType(FieldDeclaration it) {
            return it.getType();
        }

        protected TypeReference _getType(MethodDeclaration it) {
            return it.getReturnType();
        }

        public boolean hasValidSignature(MethodDeclaration it) {
            boolean _switchResult = false;
            Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                @Override
                public TypeReference apply(ParameterDeclaration it) {
                    return it.getType();
                }
            };
            List<TypeReference> _list = IterableExtensions.toList(IterableExtensions.map(it.getParameters(), _function));
            boolean _matched = false;
            if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(new Object[0])))) {
                _matched = true;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(_string)))) {
                    _matched = true;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(this.context.newTypeReference(Class.class, this.context.newWildcardTypeReference()));
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(this.context.getObject());
                if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(_string_1, _newArrayTypeReference, _newArrayTypeReference_1)))) {
                    _matched = true;
                }
            }
            if (_matched) {
                _switchResult = true;
            }
            if (!_matched) {
                boolean _xblockexpression = false;
                this.context.addError(it, "Not a valid delegate signature, use () or (String methodName) or (String methodName, Class<?>[] argumentTypes, Object[] arguments)");
                _switchResult = _xblockexpression = false;
            }
            return _switchResult;
        }

        public boolean hasDelegationConflicts(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            boolean conflict = false;
            Iterable<? extends MemberDeclaration> _otherDelegates = this.otherDelegates(delegate);
            for (MemberDeclaration memberDeclaration : _otherDelegates) {
                Set<TypeReference> otherInterfaces = this.getDelegatedInterfaces(memberDeclaration);
                Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
                for (TypeReference iface : _delegatedInterfaces) {
                    boolean _contains = otherInterfaces.contains(iface);
                    if (!_contains) continue;
                    conflict = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The interface ");
                    String _simpleName = iface.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" is also implemented by the delegate ");
                    String _simpleName_1 = memberDeclaration.getSimpleName();
                    _builder.append(_simpleName_1);
                    this.context.addError(delegate, _builder.toString());
                }
            }
            _xblockexpression = conflict;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> otherDelegates(final MemberDeclaration delegate) {
            Functions.Function1<MemberDeclaration, Boolean> _function = new Functions.Function1<MemberDeclaration, Boolean>(){

                @Override
                public Boolean apply(MemberDeclaration it) {
                    return !Objects.equal(it, delegate);
                }
            };
            return IterableExtensions.filter(this.getDelegates(delegate.getDeclaringType()), _function);
        }

        public boolean areListedInterfacesValid(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            TypeReference declaringType = this.context.newSelfTypeReference(delegate.getDeclaringType());
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(declaringType);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(this.getType(delegate));
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            boolean valid = true;
            for (final TypeReference iface : listedInterfaces) {
                Functions.Function1<TypeReference, Boolean> _function_1;
                boolean _exists_1;
                boolean _not_1;
                boolean _not;
                Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                    @Override
                    public Boolean apply(TypeReference it) {
                        Type _type = it.getType();
                        Type _type_1 = iface.getType();
                        return Objects.equal(_type, _type_1);
                    }
                };
                boolean _exists = IterableExtensions.exists(availableInterfaces, _function);
                boolean bl = _not = !_exists;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _simpleName = this.getType(delegate).getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" does not implement ");
                    String _simpleName_1 = iface.getSimpleName();
                    _builder.append(_simpleName_1);
                    this.context.addError(delegate, _builder.toString());
                    valid = false;
                }
                if (!(_not_1 = !(_exists_1 = IterableExtensions.exists(interfacesOfDeclaringType, _function_1 = new Functions.Function1<TypeReference, Boolean>(){

                    @Override
                    public Boolean apply(TypeReference it) {
                        Type _type = it.getType();
                        Type _type_1 = iface.getType();
                        return Objects.equal(_type, _type_1);
                    }
                })))) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_2 = declaringType.getSimpleName();
                _builder_1.append(_simpleName_2);
                _builder_1.append(" does not implement ");
                String _simpleName_3 = iface.getSimpleName();
                _builder_1.append(_simpleName_3);
                this.context.addError(delegate, _builder_1.toString());
                valid = false;
            }
            if (listedInterfaces.isEmpty() && Sets.intersection(interfacesOfDeclaringType, availableInterfaces).isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                String _simpleName = this.getType(delegate).getSimpleName();
                _builder.append(_simpleName);
                _builder.append(" and ");
                String _simpleName_1 = declaringType.getSimpleName();
                _builder.append(_simpleName_1);
                _builder.append(" have no interfaces in common");
                this.context.addError(delegate, _builder.toString());
                valid = false;
            }
            _xblockexpression = valid;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> getDelegates(TypeDeclaration it) {
            Functions.Function1<MemberDeclaration, Boolean> _function = new Functions.Function1<MemberDeclaration, Boolean>(){

                @Override
                public Boolean apply(MemberDeclaration it) {
                    AnnotationReference _findAnnotation = it.findAnnotation(Util.this.context.findTypeGlobally(Delegate.class));
                    return _findAnnotation != null;
                }
            };
            return IterableExtensions.filter(it.getDeclaredMembers(), _function);
        }

        public Set<TypeReference> listedInterfaces(MemberDeclaration it) {
            return IterableExtensions.toSet((Iterable)Conversions.doWrapArray(it.findAnnotation(this.context.findTypeGlobally(Delegate.class)).getClassArrayValue("value")));
        }

        public Set<TypeReference> getImplementedInterfaces(TypeReference it) {
            Set<TypeReference> _xblockexpression = null;
            LinkedHashSet<TypeReference> seen = CollectionLiterals.newLinkedHashSet(new TypeReference[0]);
            this.collectAllSuperTypes(it, seen);
            Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                @Override
                public Boolean apply(TypeReference it) {
                    Type _type = it.getType();
                    return _type instanceof InterfaceDeclaration;
                }
            };
            _xblockexpression = IterableExtensions.toSet(IterableExtensions.filter(seen, _function));
            return _xblockexpression;
        }

        private void collectAllSuperTypes(TypeReference it, final Set<TypeReference> seen) {
            boolean cycle;
            boolean _add = seen.add(it);
            boolean bl = cycle = !_add;
            if (cycle) {
                return;
            }
            Consumer<TypeReference> _function = new Consumer<TypeReference>(){

                @Override
                public void accept(TypeReference it) {
                    Util.this.collectAllSuperTypes(it, seen);
                }
            };
            it.getDeclaredSuperTypes().forEach((Consumer<? extends TypeReference>)_function);
        }

        public Set<TypeReference> getDelegatedInterfaces(MemberDeclaration delegate) {
            Set<TypeReference> _xblockexpression = null;
            final Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(this.context.newSelfTypeReference(delegate.getDeclaringType()));
            final Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(this.getType(delegate));
            Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                @Override
                public Boolean apply(final TypeReference iface) {
                    return interfacesOfDeclaringType.contains(iface) && (listedInterfaces.isEmpty() || IterableExtensions.exists(listedInterfaces, new Functions.Function1<TypeReference, Boolean>(){

                        @Override
                        public Boolean apply(TypeReference it) {
                            return iface.isAssignableFrom(it);
                        }
                    }));
                }
            };
            _xblockexpression = IterableExtensions.toSet(IterableExtensions.filter(availableInterfaces, _function));
            return _xblockexpression;
        }

        public Set<ResolvedMethod> getMethodsToImplement(final MemberDeclaration delegate) {
            Functions.Function1<TypeReference, Iterable<? extends ResolvedMethod>> _function = new Functions.Function1<TypeReference, Iterable<? extends ResolvedMethod>>(){

                @Override
                public Iterable<? extends ResolvedMethod> apply(TypeReference it) {
                    return it.getDeclaredResolvedMethods();
                }
            };
            Functions.Function1<ResolvedMethod, Boolean> _function_1 = new Functions.Function1<ResolvedMethod, Boolean>(){

                @Override
                public Boolean apply(ResolvedMethod it) {
                    Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                        @Override
                        public TypeReference apply(ResolvedParameter it) {
                            return it.getResolvedType();
                        }
                    };
                    MethodDeclaration _findDeclaredMethod = delegate.getDeclaringType().findDeclaredMethod(it.getDeclaration().getSimpleName(), (TypeReference[])Conversions.unwrapArray(IterableExtensions.map(it.getResolvedParameters(), _function), TypeReference.class));
                    return _findDeclaredMethod == null;
                }
            };
            Functions.Function1<ResolvedMethod, Boolean> _function_2 = new Functions.Function1<ResolvedMethod, Boolean>(){

                @Override
                public Boolean apply(ResolvedMethod it) {
                    boolean _isObjectMethod = Util.this.isObjectMethod(it);
                    return !_isObjectMethod;
                }
            };
            Functions.Function1<ResolvedMethod, String> _function_3 = new Functions.Function1<ResolvedMethod, String>(){

                @Override
                public String apply(ResolvedMethod it) {
                    return it.getSimpleSignature();
                }
            };
            Functions.Function1<List<ResolvedMethod>, ResolvedMethod> _function_4 = new Functions.Function1<List<ResolvedMethod>, ResolvedMethod>(){

                @Override
                public ResolvedMethod apply(List<ResolvedMethod> it) {
                    return IterableExtensions.head(it);
                }
            };
            return IterableExtensions.toSet(IterableExtensions.map(IterableExtensions.groupBy(IterableExtensions.filter(IterableExtensions.filter(Iterables.concat(IterableExtensions.map(this.getDelegatedInterfaces(delegate), _function)), _function_1), _function_2), _function_3).values(), _function_4));
        }

        public boolean isObjectMethod(ResolvedMethod it) {
            boolean _xblockexpression = false;
            String name = it.getDeclaration().getSimpleName();
            Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                @Override
                public TypeReference apply(ResolvedParameter it) {
                    return it.getResolvedType();
                }
            };
            List<TypeReference> parameterTypes = IterableExtensions.toList(IterableExtensions.map(it.getResolvedParameters(), _function));
            _xblockexpression = Objects.equal(name, "hashCode") && parameterTypes.isEmpty() || Objects.equal(name, "toString") && parameterTypes.isEmpty() || Objects.equal(name, "equals") && Objects.equal(parameterTypes, Collections.unmodifiableList(CollectionLiterals.newArrayList(this.context.getObject()))) || Objects.equal(name, "finalize") && parameterTypes.isEmpty() || Objects.equal(name, "clone") && parameterTypes.isEmpty();
            return _xblockexpression;
        }

        public MutableMethodDeclaration implementMethod(final MutableMemberDeclaration delegate, final ResolvedMethod resolvedMethod) {
            MutableMethodDeclaration _xblockexpression = null;
            delegate.markAsRead();
            final MethodDeclaration declaration = resolvedMethod.getDeclaration();
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                @Override
                public void apply(final MutableMethodDeclaration impl) {
                    Util.this.context.setPrimarySourceElement(impl, Util.this.context.getPrimarySourceElement(delegate));
                    final HashMap typeParameterMappings = CollectionLiterals.newHashMap(new Pair[0]);
                    Consumer<ResolvedTypeParameter> _function = new Consumer<ResolvedTypeParameter>(){

                        @Override
                        public void accept(ResolvedTypeParameter param) {
                            MutableTypeParameterDeclaration copy = impl.addTypeParameter(param.getDeclaration().getSimpleName(), (TypeReference[])Conversions.unwrapArray(param.getResolvedUpperBounds(), TypeReference.class));
                            typeParameterMappings.put(Util.this.context.newTypeReference(param.getDeclaration(), new TypeReference[0]), Util.this.context.newTypeReference(copy, new TypeReference[0]));
                            Functions.Function1<TypeReference, TypeReference> _function = new Functions.Function1<TypeReference, TypeReference>(){

                                @Override
                                public TypeReference apply(TypeReference it) {
                                    return Util.this.replace(it, typeParameterMappings);
                                }
                            };
                            copy.setUpperBounds(IterableExtensions.map(copy.getUpperBounds(), _function));
                        }
                    };
                    resolvedMethod.getResolvedTypeParameters().forEach((Consumer<? extends ResolvedTypeParameter>)_function);
                    Functions.Function1<TypeReference, TypeReference> _function_1 = new Functions.Function1<TypeReference, TypeReference>(){

                        @Override
                        public TypeReference apply(TypeReference it) {
                            return Util.this.replace(it, typeParameterMappings);
                        }
                    };
                    impl.setExceptions((TypeReference[])Conversions.unwrapArray(IterableExtensions.map(resolvedMethod.getResolvedExceptionTypes(), _function_1), TypeReference.class));
                    impl.setVarArgs(declaration.isVarArgs());
                    impl.setReturnType(Util.this.replace(resolvedMethod.getResolvedReturnType(), typeParameterMappings));
                    Consumer<ResolvedParameter> _function_2 = new Consumer<ResolvedParameter>(){

                        @Override
                        public void accept(ResolvedParameter p) {
                            impl.addParameter(p.getDeclaration().getSimpleName(), Util.this.replace(p.getResolvedType(), typeParameterMappings));
                        }
                    };
                    resolvedMethod.getResolvedParameters().forEach((Consumer<? extends ResolvedParameter>)_function_2);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            String _returnIfNeeded = Util.this.returnIfNeeded(resolvedMethod);
                            _builder.append(_returnIfNeeded);
                            CharSequence _delegateAccess = Util.this.delegateAccess(delegate, declaration);
                            _builder.append(_delegateAccess);
                            _builder.append(".");
                            String _simpleName = declaration.getSimpleName();
                            _builder.append(_simpleName);
                            _builder.append("(");
                            Functions.Function1<ParameterDeclaration, CharSequence> _function = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                                @Override
                                public CharSequence apply(ParameterDeclaration it) {
                                    return it.getSimpleName();
                                }
                            };
                            String _join = IterableExtensions.join(declaration.getParameters(), ", ", _function);
                            _builder.append(_join);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    impl.setBody(_client);
                }
            };
            _xblockexpression = delegate.getDeclaringType().addMethod(declaration.getSimpleName(), _function);
            return _xblockexpression;
        }

        public TypeReference replace(TypeReference target, Map<? extends TypeReference, ? extends TypeReference> mappings) {
            Functions.Function2<TypeReference, Map.Entry<? extends TypeReference, ? extends TypeReference>, TypeReference> _function = new Functions.Function2<TypeReference, Map.Entry<? extends TypeReference, ? extends TypeReference>, TypeReference>(){

                @Override
                public TypeReference apply(TypeReference result, Map.Entry<? extends TypeReference, ? extends TypeReference> mapping) {
                    return Util.this.replace(result, mapping.getKey(), mapping.getValue());
                }
            };
            return IterableExtensions.fold(mappings.entrySet(), target, _function);
        }

        public TypeReference replace(TypeReference target, final TypeReference oldType, final TypeReference newType) {
            boolean _isArray;
            boolean _not;
            boolean _equals = Objects.equal(target, oldType);
            if (_equals) {
                return newType;
            }
            boolean _isEmpty = target.getActualTypeArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Functions.Function1<TypeReference, TypeReference> _function = new Functions.Function1<TypeReference, TypeReference>(){

                    @Override
                    public TypeReference apply(TypeReference it) {
                        return Util.this.replace(it, oldType, newType);
                    }
                };
                return this.context.newTypeReference(target.getType(), (TypeReference[])Conversions.unwrapArray(ListExtensions.map(target.getActualTypeArguments(), _function), TypeReference.class));
            }
            boolean _isWildCard = target.isWildCard();
            if (_isWildCard) {
                boolean _not_1;
                TypeReference _object;
                boolean _notEquals;
                TypeReference _upperBound = target.getUpperBound();
                boolean bl2 = _notEquals = !Objects.equal(_upperBound, _object = this.context.getObject());
                if (_notEquals) {
                    return this.context.newWildcardTypeReference(this.replace(target.getUpperBound(), oldType, newType));
                }
                boolean _isAnyType = target.getLowerBound().isAnyType();
                boolean bl3 = _not_1 = !_isAnyType;
                if (_not_1) {
                    return this.context.newWildcardTypeReferenceWithLowerBound(this.replace(target.getLowerBound(), oldType, newType));
                }
            }
            if (_isArray = target.isArray()) {
                return this.context.newArrayTypeReference(this.replace(target.getArrayComponentType(), oldType, newType));
            }
            return target;
        }

        protected CharSequence _delegateAccess(FieldDeclaration it, MethodDeclaration method) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this.");
            String _simpleName = it.getSimpleName();
            _builder.append(_simpleName);
            return _builder;
        }

        protected CharSequence _delegateAccess(MethodDeclaration it, MethodDeclaration method) {
            StringConcatenation _switchResult = null;
            Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                @Override
                public TypeReference apply(ParameterDeclaration it) {
                    return it.getType();
                }
            };
            List<TypeReference> _list = IterableExtensions.toList(IterableExtensions.map(it.getParameters(), _function));
            boolean _matched = false;
            if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(new Object[0])))) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("this.");
                String _simpleName = it.getSimpleName();
                _builder.append(_simpleName);
                _builder.append("()");
                _switchResult = _builder;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(_string)))) {
                    _matched = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("this.");
                    String _simpleName_1 = it.getSimpleName();
                    _builder_1.append(_simpleName_1);
                    _builder_1.append("(\"");
                    String _simpleName_2 = method.getSimpleName();
                    _builder_1.append(_simpleName_2);
                    _builder_1.append("\")");
                    _switchResult = _builder_1;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(this.context.newTypeReference(Class.class, this.context.newWildcardTypeReference()));
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(this.context.getObject());
                if (Objects.equal(_list, Collections.unmodifiableList(CollectionLiterals.newArrayList(_string_1, _newArrayTypeReference, _newArrayTypeReference_1)))) {
                    _matched = true;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("this.");
                    String _simpleName_3 = it.getSimpleName();
                    _builder_2.append(_simpleName_3);
                    _builder_2.append("(\"");
                    String _simpleName_4 = method.getSimpleName();
                    _builder_2.append(_simpleName_4);
                    _builder_2.append("\", new Class[]{");
                    Functions.Function1<ParameterDeclaration, CharSequence> _function_1 = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                        @Override
                        public CharSequence apply(ParameterDeclaration it) {
                            String _simpleName = it.getType().getType().getSimpleName();
                            return _simpleName + ".class";
                        }
                    };
                    String _join = IterableExtensions.join(method.getParameters(), ", ", _function_1);
                    _builder_2.append(_join);
                    _builder_2.append("}, new Object[]{");
                    Functions.Function1<ParameterDeclaration, CharSequence> _function_2 = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                        @Override
                        public CharSequence apply(ParameterDeclaration it) {
                            return it.getSimpleName();
                        }
                    };
                    String _join_1 = IterableExtensions.join(method.getParameters(), ", ", _function_2);
                    _builder_2.append(_join_1);
                    _builder_2.append("})");
                    _switchResult = _builder_2;
                }
            }
            if (!_matched) {
                throw new IllegalArgumentException("delegate signature");
            }
            return _switchResult;
        }

        public String returnIfNeeded(ResolvedMethod it) {
            String _xifexpression = null;
            boolean _isVoid = it.getResolvedReturnType().isVoid();
            _xifexpression = _isVoid ? "" : "return ";
            return _xifexpression;
        }

        public boolean isValidDelegate(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._isValidDelegate((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._isValidDelegate((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public TypeReference getType(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._getType((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._getType((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public CharSequence delegateAccess(MemberDeclaration it, MethodDeclaration method) {
            if (it instanceof MethodDeclaration) {
                return this._delegateAccess((MethodDeclaration)it, method);
            }
            if (it instanceof FieldDeclaration) {
                return this._delegateAccess((FieldDeclaration)it, method);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, method).toString());
        }
    }
}

