/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class RelaxNGValidator {
    private static final Logger LOGR = Logger.getLogger(RelaxNGValidator.class.getPackage().getName());
    private static final String RELAXNG_COMPACT_FACTORY = "com.thaiopensource.relaxng.jaxp.CompactSyntaxSchemaFactory";
    private static final String RELAXNG_XML_FACTORY = "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory";
    private Validator validator;

    public RelaxNGValidator(URL rngSchemaURL) throws SAXException, IOException {
        this(rngSchemaURL, null);
    }

    public RelaxNGValidator(URL rngSchemaURL, LSResourceResolver resolver2) throws SAXException, IOException {
        if (null == rngSchemaURL) {
            throw new IllegalArgumentException("No schema URL supplied.");
        }
        Schema schema = this.createRelaxNGSchema(rngSchemaURL, resolver2);
        this.validator = schema.newValidator();
    }

    public ValidationErrorHandler getErrorHandler() {
        return (ValidationErrorHandler)this.validator.getErrorHandler();
    }

    public void validate(Source source) throws SAXException, IOException {
        if (null == source) {
            throw new NullPointerException("source is null.");
        }
        if (DOMSource.class.isInstance(source)) {
            source = RelaxNGValidator.toStreamSource((DOMSource)source);
        }
        this.validator.setErrorHandler(new ValidationErrorHandler());
        this.validator.validate(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Schema createRelaxNGSchema(URL schemaURL, LSResourceResolver resolver2) throws SAXException, IOException {
        InputStream schemaStream;
        BufferedInputStream bufStream;
        boolean isXMLSyntax;
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine("Attempting to create RELAX NG Schema object from schemaURL = " + schemaURL.toString());
        }
        SchemaFactory schemaFactory = (isXMLSyntax = this.isXMLStream(bufStream = new BufferedInputStream(schemaStream = schemaURL.openStream(), 8192))) ? SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0", RELAXNG_XML_FACTORY, null) : SchemaFactory.newInstance("http://www.iana.org/assignments/media-types/application/relax-ng-compact-syntax", RELAXNG_COMPACT_FACTORY, null);
        if (null != resolver2) {
            schemaFactory.setResourceResolver(resolver2);
        }
        Schema schema = null;
        try {
            StreamSource source = new StreamSource(bufStream);
            source.setSystemId(schemaURL.toURI().toString());
            schema = schemaFactory.newSchema(source);
        }
        catch (URISyntaxException e) {
            LOGR.log(Level.INFO, null, e);
        }
        finally {
            try {
                bufStream.close();
            }
            catch (IOException iox) {
                LOGR.log(Level.INFO, null, iox);
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isXMLStream(BufferedInputStream bufStream) {
        bufStream.mark(8192);
        boolean isXML = true;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(bufStream);
            reader.nextTag();
        }
        catch (XMLStreamException xse) {
            isXML = false;
        }
        finally {
            try {
                bufStream.reset();
            }
            catch (IOException x) {
                LOGR.log(Level.INFO, "Error resetting BufferedInputStream", x);
            }
        }
        return isXML;
    }

    static StreamSource toStreamSource(DOMSource domSource) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        try {
            Transformer idt = TransformerFactory.newInstance().newTransformer();
            idt.transform(domSource, result);
        }
        catch (TransformerException tex) {
            LOGR.log(Level.WARNING, "Error serializing DOMSource.", tex);
        }
        return new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
    }
}

