/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.ChildOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ListOverlay<V>
extends JsonOverlay<Collection<V>> {
    private OverlayFactory<V> itemFactory;
    private List<AbstractJsonOverlay<V>> overlays = Lists.newLinkedList();

    public ListOverlay(Collection<V> value, JsonOverlay<?> parent, OverlayFactory<V> itemFactory, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.itemFactory = itemFactory;
    }

    public ListOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> itemFactory, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.itemFactory = itemFactory;
    }

    @Override
    protected void elaborate() {
        if (this.json != null) {
            this.fillWithJson();
        } else {
            this.fillWithValues();
        }
    }

    private void fillWithValues() {
        this.overlays.clear();
        if (this.value != null) {
            for (Object item : (Collection)this.value) {
                this.overlays.add(new ChildOverlay(null, item, this, this.itemFactory, this.refReg));
            }
        }
    }

    private void fillWithJson() {
        ((Collection)this.value).clear();
        this.overlays.clear();
        if (!this.json.isMissingNode()) {
            for (JsonNode itemJson : ListOverlay.iterable(this.json.elements())) {
                ChildOverlay<V> overlay = new ChildOverlay<V>(null, itemJson, (JsonOverlay<?>)this, this.itemFactory, this.refReg);
                this.overlays.add(overlay);
                ((Collection)this.value).add(overlay._get(false));
            }
        }
    }

    @Override
    Collection<V> _get() {
        return this.wrap((Collection)this.value);
    }

    private Collection<V> wrap(Collection<V> list) {
        if (list instanceof WrappedCollection) {
            return list;
        }
        return new WrappedCollection<V>(list, this);
    }

    AbstractJsonOverlay<V> _get(int index) {
        return this.overlays.get(index);
    }

    @Override
    protected Collection<V> fromJson(JsonNode json) {
        return Lists.newArrayList();
    }

    @Override
    public AbstractJsonOverlay<?> _findInternal(JsonPointer path) {
        int index = path.getMatchingIndex();
        return this.overlays.size() > index ? this.overlays.get(index)._find(path.tail()) : null;
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        ArrayNode array = ListOverlay.jsonArray();
        for (AbstractJsonOverlay<V> overlay : this.overlays) {
            array.add(overlay._toJson(options.plus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return array.size() > 0 || options.isKeepThisEmpty() ? array : ListOverlay.jsonMissing();
    }

    public V get(int index) {
        AbstractJsonOverlay<V> overlay = this.overlays.get(index);
        return overlay != null ? (V)overlay._get() : null;
    }

    public AbstractJsonOverlay<V> getOverlay(int index) {
        return this.overlays.get(index);
    }

    public void set(int index, V value) {
        this.overlays.set(index, this.itemFactory.create(value, this, this.refReg, null));
    }

    public void add(V value) {
        this.overlays.add(this.itemFactory.create(value, this, this.refReg, null));
    }

    public void insert(int index, V value) {
        this.overlays.add(index, this.itemFactory.create(value, this, this.refReg, null));
    }

    public void remove(int index) {
        this.overlays.remove(index);
    }

    public int size() {
        return this.overlays.size();
    }

    public boolean isReference(int index) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(index);
        return childOverlay.isReference();
    }

    public Reference getReference(int index) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(index);
        return childOverlay.getReference();
    }

    public static <V> OverlayFactory<Collection<V>> getFactory(OverlayFactory<V> itemFactory) {
        return new ListOverlayFactory<V>(itemFactory);
    }

    static class WrappedCollection<V>
    implements Collection<V> {
        private Collection<V> collection;
        private ListOverlay<V> overlay;

        public WrappedCollection(Collection<V> collection, ListOverlay<V> overlay) {
            this.collection = collection;
            this.overlay = overlay;
        }

        public ListOverlay<V> getOverlay() {
            return this.overlay;
        }

        @Override
        public boolean add(V arg0) {
            return this.collection.add(arg0);
        }

        @Override
        public boolean addAll(Collection<? extends V> arg0) {
            return this.collection.addAll(arg0);
        }

        @Override
        public void clear() {
            this.collection.clear();
        }

        @Override
        public boolean contains(Object arg0) {
            return this.collection.contains(arg0);
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return this.collection.containsAll(arg0);
        }

        @Override
        public void forEach(Consumer<? super V> arg0) {
            this.collection.forEach(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return this.collection.iterator();
        }

        @Override
        public Stream<V> parallelStream() {
            return this.collection.parallelStream();
        }

        @Override
        public boolean remove(Object arg0) {
            return this.collection.remove(arg0);
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return this.collection.removeAll(arg0);
        }

        @Override
        public boolean removeIf(Predicate<? super V> arg0) {
            return this.collection.removeIf(arg0);
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return this.collection.retainAll(arg0);
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Spliterator<V> spliterator() {
            return this.collection.spliterator();
        }

        @Override
        public Stream<V> stream() {
            return this.collection.stream();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return this.collection.toArray(arg0);
        }
    }

    private static class ListOverlayFactory<V>
    extends OverlayFactory<Collection<V>> {
        private OverlayFactory<V> itemFactory;

        public ListOverlayFactory(OverlayFactory<V> itemFactory) {
            this.itemFactory = itemFactory;
        }

        @Override
        protected Class<? extends JsonOverlay<Collection<V>>> getOverlayClass() {
            Class<ListOverlay> overlayClass;
            Class<ListOverlay> castClass = overlayClass = ListOverlay.class;
            return castClass;
        }

        @Override
        public ListOverlay<V> _create(Collection<V> value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new ListOverlay<V>(value, parent, this.itemFactory, refReg);
        }

        @Override
        public ListOverlay<V> _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new ListOverlay<V>(json, parent, this.itemFactory, refReg);
        }
    }
}

