/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.kaizen.oasparser.model3.Header;
import com.reprezen.kaizen.oasparser.model3.Link;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LinkValidator
extends ObjectValidatorBase<Link> {
    @Inject
    private Validator<Header> headerValidator;

    @Override
    public void validateObject(Link link, ValidationResults results) {
        Operation op = this.checkValidOperation(link, results);
        if (op != null) {
            this.checkParameters(link, op, results);
        }
        this.validateMap(link.getHeaders(), results, false, "headers", Regexes.NOEXT_REGEX, this.headerValidator);
        this.validateExtensions(link.getExtensions(), results);
    }

    private Operation checkValidOperation(Link link, ValidationResults results) {
        String relativePath;
        String opId = link.getOperationId();
        String operationRef = link.getOperationRef();
        Operation op = null;
        if (opId == null && operationRef == null) {
            results.addError(Messages.m.msg("NoOpIdNoOpRefInLink|Link must contain eitehr 'operationRef' or 'operationId' properties", new Object[0]));
        } else if (opId != null && operationRef != null) {
            results.addError(Messages.m.msg("OpIdAndOpRefInLink|Link may not contain both 'operationRef' and 'operationId' properties", new Object[0]));
        }
        if (opId != null && (op = this.findOperationById((OpenApi3)Overlay.getModel((IJsonOverlay)link), opId)) == null) {
            results.addError(Messages.m.msg("OpIdNotFound|OperationId in Link does not identify an operation in the containing model", opId), "operationId");
        }
        if ((relativePath = this.getRelativePath(operationRef, results)) != null && (op = this.findOperationByPath((OpenApi3)Overlay.getModel((IJsonOverlay)link), relativePath, results)) == null) {
            results.addError(Messages.m.msg("OpPathNotFound|Relative OperationRef in Link does not identify a GET operation in the containing model", operationRef), "operationRef");
        }
        return op;
    }

    private void checkParameters(Link link, Operation op, ValidationResults results) {
        Map<String, Integer> opParamCounts = this.getParamNameCounts(op.getParameters());
        for (String paramName : link.getParameters().keySet()) {
            int count = opParamCounts.get(paramName);
            if (count == 0) {
                results.addError(Messages.m.msg("BadLinkParam|Link parameter does not appear in linked operation", paramName), paramName);
                continue;
            }
            if (count <= 1) continue;
            results.addWarning(Messages.m.msg("AmbigLinkParam|Link parameter name appears more than once in linked operation", paramName), paramName);
        }
    }

    private Operation findOperationById(OpenApi3 model, String operationId) {
        for (Path path : model.getPaths().values()) {
            for (Operation op : path.getOperations().values()) {
                if (!operationId.equals(op.getOperationId())) continue;
                return op;
            }
        }
        return null;
    }

    private Operation findOperationByPath(OpenApi3 model, String relativePath, ValidationResults results) {
        Path path = model.getPath(relativePath);
        return path != null ? path.getGet(false) : null;
    }

    private String getRelativePath(String operationRef, ValidationResults results) {
        if (operationRef != null) {
            results.addWarning("OperationRefUnSupp|Link.operationRef is not yet supported", "operationRef");
        }
        return null;
    }

    private Map<String, Integer> getParamNameCounts(Collection<? extends Parameter> parameters) {
        HashMap counts = Maps.newHashMap();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            if (counts.containsKey(name)) {
                counts.put(name, 1 + (Integer)counts.get(name));
                continue;
            }
            counts.put(name, 1);
        }
        return counts;
    }
}

