/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.collections;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.wfs30.CommonDataFixture;
import org.opengis.cite.wfs30.EtsAssert;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GetFeatureOperation
extends CommonDataFixture {
    private OpenApi3 apiModel;
    private List<Map<String, Object>> collections;
    private final Map<String, Response> collectionNameAndResponse = new HashMap<String, Response>();

    @DataProvider(name="collectionFeatureId")
    public Iterator<Object[]> collectionFeatureId(ITestContext testContext) {
        Map collectionNameToFeatureId = (Map)testContext.getSuite().getAttribute(SuiteAttribute.FEATUREIDS.getName());
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            String collectionName = (String)collection.get("name");
            String featureId = null;
            if (collectionNameToFeatureId != null) {
                featureId = (String)collectionNameToFeatureId.get(collectionName);
            }
            collectionsData.add(new Object[]{collection, featureId});
        }
        return collectionsData.iterator();
    }

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        this.collections = (List)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS.getName());
    }

    @Test(description="Implements A.4.4.14. Get Feature Operation (Requirement 30, 31)", dataProvider="collectionFeatureId", dependsOnGroups={"getFeaturesBase"}, alwaysRun=true)
    public void getFeatureOperation(Map<String, Object> collection, String featureId) {
        String collectionName = (String)collection.get("name");
        if (featureId == null) {
            throw new SkipException("No featureId available for collection '" + collectionName + "'");
        }
        String getFeatureUrl = this.findGetFeatureUrlForGeoJson(collection);
        if (getFeatureUrl == null) {
            throw new SkipException("Could not find url for collection with name " + collectionName + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        String getFeatureUrlWithFeatureId = getFeatureUrl.substring(0, getFeatureUrl.indexOf("?")) + "/" + featureId;
        Response response = (Response)this.init().baseUri(getFeatureUrlWithFeatureId).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.collectionNameAndResponse.put(collectionName, response);
    }

    @Test(description="Implements A.4.4.15. Validate the Get Feature Operation Response (Requirement 32)", dataProvider="collectionFeatureId", dependsOnMethods={"getFeatureOperation"}, alwaysRun=true)
    public void validateTheGetFeatureOperationResponse(Map<String, Object> collection, String featureId) {
        String collectionName = (String)collection.get("name");
        Response response = this.collectionNameAndResponse.get(collectionName);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with name " + collectionName);
        }
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, (String)"Get Feature Operation Response must include a link for itself");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToSelf), "Link to itself must include a rel and type parameter");
        Map<String, Object> linkToCollection = JsonUtils.findLinkByRel(links, "collection");
        Assert.assertNotNull(linkToCollection, (String)"Get Feature Operation Response must include a link for the feature collection");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToCollection), "Link to feature collection must include a rel and type parameter");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Get Feature Operation Response must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(links);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings in Get Feature Operation Response must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    private String findGetFeatureUrlForGeoJson(Map<String, Object> collection) {
        List links = (List)collection.get("links");
        for (Object linkObject : links) {
            Map link = (Map)linkObject;
            Object rel = link.get("rel");
            Object type = link.get("type");
            if (!"item".equals(rel) || !"application/geo+json".equals(type)) continue;
            return (String)link.get("href");
        }
        return null;
    }
}

