/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class BBox {
    private static final String PATTERN = "###.0000000";
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public BBox(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public String asQueryParameter() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat formatter = this.formatter();
        sb.append(formatter.format(this.minX)).append(",");
        sb.append(formatter.format(this.minY)).append(",");
        sb.append(formatter.format(this.maxX)).append(",");
        sb.append(formatter.format(this.maxY));
        return sb.toString();
    }

    public String toString() {
        return this.asQueryParameter();
    }

    private DecimalFormat formatter() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(PATTERN);
        return df;
    }
}

