/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.reprezen.jsonoverlay.AbstractJsonOverlay;
import com.reprezen.jsonoverlay.ChildOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.Reference;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.SerializationOptions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;

public class MapOverlay<V>
extends JsonOverlay<Map<String, V>> {
    private Map<String, AbstractJsonOverlay<V>> overlays = Maps.newLinkedHashMap();
    private OverlayFactory<V> valueFactory;
    private Pattern keyPattern;

    public MapOverlay(Map<String, V> value, JsonOverlay<?> parent, OverlayFactory<V> valueFactory, Pattern keyPattern, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.valueFactory = valueFactory;
        this.keyPattern = keyPattern;
    }

    public MapOverlay(JsonNode json, JsonOverlay<?> parent, OverlayFactory<V> valueFactory, Pattern keyPattern, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.valueFactory = valueFactory;
        this.keyPattern = keyPattern;
    }

    @Override
    protected void elaborate() {
        if (this.json != null) {
            this.fillWithJson();
        } else {
            this.fillWithValues();
        }
    }

    private void fillWithValues() {
        this.overlays.clear();
        if (this.value != null) {
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                this.overlays.put((String)entry.getKey(), new ChildOverlay((String)entry.getKey(), entry.getValue(), this, this.valueFactory, this.refReg));
            }
        }
    }

    private void fillWithJson() {
        ((Map)this.value).clear();
        this.overlays.clear();
        if (!this.json.isMissingNode()) {
            for (Map.Entry<String, JsonNode> field : MapOverlay.iterable(this.json.fields())) {
                String key = field.getKey();
                if (this.keyPattern != null && !this.keyPattern.matcher(key).matches()) continue;
                ChildOverlay<V> overlay = new ChildOverlay<V>(key, this.json.get(key), (JsonOverlay<?>)this, this.valueFactory, this.refReg);
                this.overlays.put(key, overlay);
                overlay.getOverlay().setPathInParent(key);
                ((Map)this.value).put(key, overlay._get(false));
            }
        }
    }

    @Override
    public Map<String, V> _get() {
        return this.wrap((Map)this.value);
    }

    private Map<String, V> wrap(Map<String, V> map) {
        return map instanceof WrappedMap ? map : new WrappedMap(map, this);
    }

    AbstractJsonOverlay<V> _get(String key) {
        return this.overlays.get(key);
    }

    @Override
    public AbstractJsonOverlay<?> _findInternal(JsonPointer path) {
        String key = path.getMatchingProperty();
        return this.overlays.containsKey(key) ? this.overlays.get(key)._find(path.tail()) : null;
    }

    @Override
    protected Map<String, V> fromJson(JsonNode json) {
        return Maps.newLinkedHashMap();
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        ObjectNode obj = MapOverlay.jsonObject();
        for (Map.Entry<String, AbstractJsonOverlay<V>> entry : this.overlays.entrySet()) {
            obj.set(entry.getKey(), entry.getValue()._toJson(options.plus(SerializationOptions.Option.KEEP_ONE_EMPTY)));
        }
        return obj.size() > 0 || options.isKeepThisEmpty() ? obj : MapOverlay.jsonMissing();
    }

    public boolean containsKey(String name) {
        return this.overlays.containsKey(name);
    }

    public V get(String name) {
        AbstractJsonOverlay<V> overlay = this.overlays.get(name);
        return overlay != null ? (V)overlay._get() : null;
    }

    protected AbstractJsonOverlay<V> getOverlay(String name) {
        return this.overlays.get(name);
    }

    public void set(String name, V value) {
        this.overlays.put(name, this.valueFactory.create(value, this, this.refReg, null));
    }

    public void remove(String name) {
        this.overlays.remove(name);
    }

    public int size() {
        return this.overlays.size();
    }

    public Pattern getKeyPattern() {
        return this.keyPattern;
    }

    public Set<String> keySet() {
        return this.overlays.keySet();
    }

    public boolean isReference(String key) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(key);
        return childOverlay.isReference();
    }

    public Reference getReference(String key) {
        ChildOverlay childOverlay = (ChildOverlay)this.overlays.get(key);
        return childOverlay.getReference();
    }

    public static <V> OverlayFactory<Map<String, V>> getFactory(OverlayFactory<V> valueFactory, String keyPattern) {
        return new MapOverlayFactory<V>(valueFactory, MapOverlay.getWholeMatchPattern(keyPattern));
    }

    private static Pattern getWholeMatchPattern(String pat) {
        return pat != null ? Pattern.compile("^" + pat + "$") : null;
    }

    static class WrappedMap<V>
    implements Map<String, V> {
        Map<String, V> map;
        MapOverlay<V> overlay;

        public WrappedMap(Map<String, V> map, MapOverlay<V> overlay) {
            this.map = map;
            this.overlay = overlay;
        }

        public MapOverlay<V> getOverlay() {
            return this.overlay;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
            return this.map.compute(key, remappingFunction);
        }

        @Override
        public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
            return this.map.computeIfAbsent(key, mappingFunction);
        }

        @Override
        public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
            return this.map.computeIfPresent(key, remappingFunction);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super V> action) {
            this.map.forEach(action);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            return this.map.getOrDefault(key, defaultValue);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public V merge(String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        }

        @Override
        public V put(String key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> m) {
            this.map.putAll(m);
        }

        @Override
        public V putIfAbsent(String key, V value) {
            return this.map.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.map.remove(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public boolean replace(String key, V oldValue, V newValue) {
            return this.map.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(String key, V value) {
            return this.map.replace(key, value);
        }

        @Override
        public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
            this.map.replaceAll(function);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }
    }

    protected static class MapOverlayFactory<V>
    extends OverlayFactory<Map<String, V>> {
        private OverlayFactory<V> valueFactory;
        private Pattern keyPattern;

        public MapOverlayFactory(OverlayFactory<V> valueFactory, Pattern keyPattern) {
            this.valueFactory = valueFactory;
            this.keyPattern = keyPattern;
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }

        @Override
        protected Class<? extends JsonOverlay<Map<String, V>>> getOverlayClass() {
            Class<MapOverlay> overlayClass;
            Class<MapOverlay> castClass = overlayClass = MapOverlay.class;
            return castClass;
        }

        @Override
        public MapOverlay<V> _create(Map<String, V> value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new MapOverlay<V>(value, parent, this.valueFactory, this.keyPattern, refReg);
        }

        @Override
        public MapOverlay<V> _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new MapOverlay<V>(json, parent, this.valueFactory, this.keyPattern, refReg);
        }
    }
}

