/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.kaizen.oasparser.model3.Header;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class HeaderValidator
extends ObjectValidatorBase<Header> {
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<MediaType> mediaTypeValidator;

    @Override
    public void validateObject(Header header, ValidationResults results) {
        this.validateString(header.getName(), results, false, "name");
        this.validateString(header.getIn(), results, false, Regexes.PARAM_IN_REGEX, "in");
        this.checkPathParam(header, results);
        this.checkRequired(header, results);
        this.validateString(header.getStyle(), results, false, Regexes.STYLE_REGEX, "style");
        this.checkAllowReserved(header, results);
        this.validateField(header.getSchema(false), results, false, "schema", this.schemaValidator);
        this.validateMap(header.getContentMediaTypes(), results, false, "content", Regexes.NOEXT_REGEX, this.mediaTypeValidator);
        this.validateExtensions(header.getExtensions(), results);
    }

    private void checkPathParam(Header header, ValidationResults results) {
        if (header.getIn() != null && header.getIn().equals("path") && header.getName() != null) {
            String path = this.getPathString(header);
            if (path != null) {
                if (!path.matches(".*/\\{" + header.getName() + "\\}(/.*)?")) {
                    results.addError(Messages.m.msg("MissingPathTplt|No template for path parameter in path string", header.getName(), path), "name");
                }
            } else {
                results.addWarning(Messages.m.msg("NoPath|Could not locate path for parameter", header.getName(), header.getIn()));
            }
        }
    }

    private void checkRequired(Header header, ValidationResults results) {
        if ("path".equals(header.getIn()) && header.getRequired() != Boolean.TRUE) {
            results.addError(Messages.m.msg("PathParamReq|Path param must have 'required' property set true", header.getName()), "required");
        }
    }

    private void checkAllowReserved(Header header, ValidationResults results) {
        if (header.isAllowReserved() && !"query".equals(header.getIn())) {
            results.addWarning(Messages.m.msg("NonQryAllowRsvd|AllowReserved is ignored for non-query parameter", header.getName(), header.getIn()), "allowReserved");
        }
    }

    private String getPathString(Header header) {
        PropertiesOverlay<?> parent = Overlay.getParentPropertiesOverlay(header);
        while (parent != null && !(parent instanceof Path)) {
            parent = Overlay.of(parent).getParentPropertiesOverlay();
        }
        return parent != null && parent instanceof Path ? Overlay.getPathInParent(parent) : null;
    }
}

