/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.Callback;
import com.reprezen.kaizen.oasparser.model3.ExternalDocs;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.RequestBody;
import com.reprezen.kaizen.oasparser.model3.Response;
import com.reprezen.kaizen.oasparser.model3.SecurityRequirement;
import com.reprezen.kaizen.oasparser.model3.Server;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class OperationValidator
extends ObjectValidatorBase<Operation> {
    @Inject
    private Validator<ExternalDocs> externalDocsValidator;
    @Inject
    private Validator<Parameter> parameterValidator;
    @Inject
    private Validator<RequestBody> requestBodyValidator;
    @Inject
    private Validator<Response> responseValidator;
    @Inject
    private Validator<Callback> callbackValidator;
    @Inject
    private Validator<SecurityRequirement> securityRequirementValidator;
    @Inject
    private Validator<Server> serverValidator;

    @Override
    public void validateObject(Operation operation, ValidationResults results) {
        this.checkSummaryLength(operation, results);
        this.validateField(operation.getExternalDocs(false), results, false, "externalDocs", this.externalDocsValidator);
        this.validateString(operation.getOperationId(), results, false, "operationId");
        this.validateList(operation.getParameters(), operation.hasParameters(), results, false, "parameters", this.parameterValidator);
        this.validateField(operation.getRequestBody(false), results, false, "requestBody", this.requestBodyValidator);
        this.validateMap(operation.getResponses(), results, true, "responses", Regexes.RESPONSE_REGEX, this.responseValidator);
        this.validateMap(operation.getCallbacks(), results, false, "callbacks", Regexes.NOEXT_REGEX, this.callbackValidator);
        this.validateList(operation.getSecurityRequirements(), operation.hasSecurityRequirements(), results, false, "security", this.securityRequirementValidator);
        this.validateList(operation.getServers(), operation.hasServers(), results, false, "servers", this.serverValidator);
    }

    private void checkSummaryLength(Operation operation, ValidationResults results) {
        String summary = operation.getSummary();
        if (summary != null && summary.length() > 120) {
            results.addWarning(Messages.m.msg("LongSummary|Sumamry exceeds recommended limit of 120 chars", new Object[0]), "summary");
        }
    }
}

