/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.SecurityParameter;
import com.reprezen.kaizen.oasparser.model3.SecurityRequirement;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import java.util.Map;
import java.util.Set;

public class SecurityRequirementValidator
extends ObjectValidatorBase<SecurityRequirement> {
    @Override
    public void validateObject(SecurityRequirement securityRequirement, ValidationResults results) {
        OpenApi3 model = (OpenApi3)Overlay.getModel(securityRequirement);
        Set<String> definedSchemes = model.getSecuritySchemes().keySet();
        block7: for (Map.Entry<String, SecurityParameter> entry : securityRequirement.getRequirements().entrySet()) {
            String type;
            if (!definedSchemes.contains(entry.getKey())) {
                results.addError(Messages.m.msg("UnkSecScheme|Security scheme not defined in components object", entry.getKey()));
                continue;
            }
            switch (type = model.getSecurityScheme(entry.getKey()).getType()) {
                case "oauth2": 
                case "openIdConnect": {
                    continue block7;
                }
            }
            if (entry.getValue().getParameters().isEmpty()) continue;
            results.addError(Messages.m.msg("NonEmptySecReqParms|Security requirement parameters must be empty unless scheme type is oauth2 or openIdConnect", entry.getKey(), type));
        }
    }
}

