/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.filter.cookie;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.apache.http.message.BasicHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieFilter
implements Filter {
    private CookieSpec cookieSpec = new DefaultCookieSpec();
    private BasicCookieStore cookieStore = new BasicCookieStore();

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        CookieOrigin cookieOrigin = this.cookieOriginFromUri(requestSpec.getURI());
        for (Cookie cookie : this.cookieStore.getCookies()) {
            if (!this.cookieSpec.match(cookie, cookieOrigin) || requestSpec.getCookies().hasCookieWithName(cookie.getName())) continue;
            requestSpec.cookie(cookie.getName(), cookie.getValue(), new Object[0]);
        }
        Response response = ctx.next(requestSpec, responseSpec);
        List<Cookie> responseCookies = this.extractResponseCookies(response, cookieOrigin);
        this.cookieStore.addCookies(responseCookies.toArray(new Cookie[responseCookies.size()]));
        return response;
    }

    private List<Cookie> extractResponseCookies(Response response, CookieOrigin cookieOrigin) {
        BasicHeader setCookieHeader = new BasicHeader("Set-Cookie", response.getHeader("Set-Cookie"));
        try {
            return this.cookieSpec.parse(setCookieHeader, cookieOrigin);
        }
        catch (MalformedCookieException e) {
            return Collections.emptyList();
        }
    }

    private CookieOrigin cookieOriginFromUri(String uri) {
        try {
            URL parsedUrl = new URL(uri);
            int port = parsedUrl.getPort() != -1 ? parsedUrl.getPort() : 80;
            return new CookieOrigin(parsedUrl.getHost(), port, parsedUrl.getPath(), "https".equals(parsedUrl.getProtocol()));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

