/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wfs30.conformance;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.List;
import org.opengis.cite.wfs30.CommonFixture;
import org.opengis.cite.wfs30.SuiteAttribute;
import org.opengis.cite.wfs30.conformance.RequirementClass;
import org.opengis.cite.wfs30.openapi3.OpenApiUtils;
import org.opengis.cite.wfs30.openapi3.TestPoint;
import org.opengis.cite.wfs30.openapi3.UriBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConformanceOperation
extends CommonFixture {
    private List<RequirementClass> requirementClasses;

    @DataProvider(name="conformanceUris")
    public Object[][] conformanceUris(ITestContext testContext) {
        OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForConformance(apiModel);
        return new Object[][]{testPoints.toArray()};
    }

    @AfterClass
    public void storeRequirementClassesInTestContext(ITestContext testContext) {
        testContext.getSuite().setAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName(), this.requirementClasses);
    }

    @Test(description="Implements A.4.4.2. Validate Conformance Operation (Requirement 5) and A.4.4.3. Validate Conformance Operation Response (Requirement 6)", groups={"conformance"}, dataProvider="conformanceUris", dependsOnGroups={"apidefinition"})
    public void validateConformanceOperationAndResponse(TestPoint testPoint) {
        Response response = this.validateConformanceOperation(testPoint);
        this.validateConformanceOperationResponse(response);
    }

    private Response validateConformanceOperation(TestPoint testPoint) {
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        return (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
    }

    private void validateConformanceOperationResponse(Response response) {
        ((ValidatableResponse)response.then()).statusCode(200);
        JsonPath jsonPath = response.jsonPath();
        this.requirementClasses = this.parseAndValidateRequirementClasses(jsonPath);
    }

    List<RequirementClass> parseAndValidateRequirementClasses(JsonPath jsonPath) {
        ArrayList<RequirementClass> requirementClasses = new ArrayList<RequirementClass>();
        List conformsTo = jsonPath.getList("conformsTo");
        Assert.assertNotNull(conformsTo, "Missing member 'conformsTo'.");
        for (Object conformTo : conformsTo) {
            if (conformTo instanceof String) {
                String conformanceClass = (String)conformTo;
                RequirementClass requirementClass = RequirementClass.byConformanceClass(conformanceClass);
                if (requirementClass == null) continue;
                requirementClasses.add(requirementClass);
                continue;
            }
            throw new AssertionError((Object)("At least one element array 'conformsTo' is not a string value (" + conformTo + ")"));
        }
        return requirementClasses;
    }
}

